/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.consumer.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.consumer.local.entity.Consumer;
import com.biz.crm.cps.business.consumer.local.entity.Tag;
import com.biz.crm.cps.business.consumer.local.mapper.ConsumerMapper;
import com.biz.crm.cps.business.consumer.local.mapper.TagMapper;
import com.biz.crm.cps.business.consumer.sdk.dto.ConsumerDto;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class ConsumerRepository
extends ServiceImpl<ConsumerMapper, Consumer> {
    @Resource
    private ConsumerMapper consumerMapper;
    @Resource
    private TagMapper tagMapper;

    public Page<Consumer> findByConditions(Pageable pageable, ConsumerDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<Consumer> selectPage = this.consumerMapper.findByConditions((Page<Consumer>)page, dto);
        return selectPage;
    }

    public Set<Tag> findByConsumerId(String consumerId) {
        return this.tagMapper.findByConsumerId(consumerId);
    }

    public void updateBlacklistStatusByIds(List<String> ids, String blacklistReason, String accountName, EnableStatusEnum enable) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"blacklist_status", (Object)enable.getCode());
        updateWrapper.set((Object)"modify_account", (Object)accountName);
        updateWrapper.set((Object)"modify_time", (Object)new Date());
        updateWrapper.set((Object)"blacklist_reason", (Object)blacklistReason);
        updateWrapper.in((Object)"id", ids);
        this.update((Wrapper)updateWrapper);
    }

    public List<Consumer> findByIds(List<String> ids) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"id", ids);
        return this.list((Wrapper)queryWrapper);
    }

    public Consumer findByExternalId(String externalId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"external_id", (Object)externalId);
        return (Consumer)((Object)this.getOne((Wrapper)queryWrapper));
    }

    public Consumer findByConsumerCode(String consumerCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"consumer_code", (Object)consumerCode);
        return (Consumer)((Object)this.getOne((Wrapper)queryWrapper));
    }

    public List<Consumer> findByTerminalCode(String terminalCode) {
        return this.consumerMapper.findByTerminalCode(terminalCode);
    }
}

