/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.consumer.local.service.internal;

import com.biz.crm.cps.business.consumer.local.entity.Consumer;
import com.biz.crm.cps.business.consumer.local.repository.ConsumerVoRepository;
import com.biz.crm.cps.business.consumer.local.service.ConsumerService;
import com.biz.crm.cps.business.consumer.sdk.dto.ConsumerCountDto;
import com.biz.crm.cps.business.consumer.sdk.service.ConsumerVoService;
import com.biz.crm.cps.business.consumer.sdk.vo.ConsumerVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ConsumerVoServiceImpl
implements ConsumerVoService {
    @Autowired
    private ConsumerService consumerService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private ConsumerVoRepository consumerVoRepository;

    public ConsumerVo findByExternalId(String externalId) {
        if (StringUtils.isBlank((CharSequence)externalId)) {
            return null;
        }
        Consumer consumer = this.consumerService.findByExternalId(externalId);
        if (consumer == null) {
            return null;
        }
        ConsumerVo consumerVo = (ConsumerVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)consumer, ConsumerVo.class, HashSet.class, ArrayList.class, new String[0]);
        return consumerVo;
    }

    public ConsumerVo findByConsumerCode(String consumerCode) {
        if (StringUtils.isBlank((CharSequence)consumerCode)) {
            return null;
        }
        Consumer consumer = this.consumerService.findByConsumerCode(consumerCode);
        if (consumer == null) {
            return null;
        }
        ConsumerVo consumerVo = (ConsumerVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)consumer, ConsumerVo.class, HashSet.class, ArrayList.class, new String[0]);
        return consumerVo;
    }

    public List<ConsumerVo> findByTerminalCode(String terminalCode) {
        if (StringUtils.isBlank((CharSequence)terminalCode)) {
            return Lists.newArrayList();
        }
        List<Consumer> list = this.consumerService.findByTerminalCode(terminalCode);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        Collection consumerVos = this.nebulaToolkitService.copyCollectionByWhiteList(list, Consumer.class, ConsumerVo.class, HashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)consumerVos);
    }

    public Integer countByConsumerCountDto(ConsumerCountDto dto) {
        if (dto == null) {
            dto = new ConsumerCountDto();
        }
        return this.consumerVoRepository.countByConsumerCountDto(dto);
    }
}

