/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.consumer.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.cps.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.consumer.local.entity.Consumer;
import com.biz.crm.cps.business.consumer.local.entity.Tag;
import com.biz.crm.cps.business.consumer.local.repository.ConsumerRepository;
import com.biz.crm.cps.business.consumer.local.service.ConsumerService;
import com.biz.crm.cps.business.consumer.sdk.dto.ConsumerDto;
import com.biz.crm.cps.business.consumer.sdk.event.ConsumerEventListener;
import com.biz.crm.cps.business.consumer.sdk.vo.ConsumerVo;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ConsumerServiceImpl
implements ConsumerService {
    @Autowired
    private ConsumerRepository consumerRepository;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private List<ConsumerEventListener> consumerEventListeners;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;

    @Override
    @Transactional
    public Consumer create(Consumer consumer) {
        this.createValidation(consumer);
        Consumer byExternalId = this.consumerRepository.findByExternalId(consumer.getExternalId());
        Validate.isTrue((byExternalId == null ? 1 : 0) != 0, (String)"\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u5f53\u524d\u6d88\u8d39\u8005\u5df2\u5b58\u5728\uff01", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)consumer.getConsumerCode())) {
            if (Objects.nonNull(this.generateCodeService)) {
                consumer.setConsumerCode((String)this.generateCodeService.generateCode("consumer", 1).get(0));
            } else {
                consumer.setConsumerCode(String.valueOf(System.currentTimeMillis()));
            }
        }
        consumer.setBlacklistStatus(EnableStatusEnum.DISABLE.getCode());
        consumer.setCreateTime(new Date());
        consumer.setCreateAccount(this.loginUserService.getLoginAccountName());
        consumer.setTenantCode(TenantUtils.getTenantCode());
        this.consumerRepository.save((Object)consumer);
        this.consumerRepository.insertConsumerTerminalMapping(consumer.getId(), consumer.getTerminalCode());
        return consumer;
    }

    @Override
    public Consumer findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Consumer consumer = (Consumer)((Object)this.consumerRepository.getById((Serializable)((Object)id)));
        Set<Tag> tags = this.consumerRepository.findByConsumerId(id);
        consumer.setTags(tags);
        return consumer;
    }

    @Override
    public Consumer findDetailsByExternalId(String externalId) {
        if (StringUtils.isBlank((CharSequence)externalId)) {
            return null;
        }
        Consumer consumer = this.consumerRepository.findByExternalId(externalId);
        if (consumer == null) {
            return null;
        }
        Set<Tag> tags = this.consumerRepository.findByConsumerId(consumer.getId());
        consumer.setTags(tags);
        return consumer;
    }

    @Override
    public Page<Consumer> findByConditions(Pageable pageable, ConsumerDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (dto == null) {
            dto = new ConsumerDto();
        }
        return this.consumerRepository.findByConditions(pageable, dto);
    }

    @Override
    @Transactional
    public void enable(List<String> ids, String blacklistReason) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u8bf7\u4f20\u5165\u8981\u64cd\u4f5c\u7684\u6570\u636e", (Object[])new Object[0]);
        this.consumerRepository.updateBlacklistStatusByIds(ids, blacklistReason, this.loginUserService.getLoginAccountName(), EnableStatusEnum.ENABLE);
        if (!CollectionUtils.isEmpty(this.consumerEventListeners)) {
            List<Consumer> terminals = this.consumerRepository.findByIds(ids);
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(terminals, Consumer.class, ConsumerVo.class, HashSet.class, ArrayList.class, new String[0]);
            for (ConsumerEventListener event : this.consumerEventListeners) {
                event.onEnable(voList);
            }
        }
    }

    @Override
    @Transactional
    public void disable(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u8bf7\u4f20\u5165\u8981\u64cd\u4f5c\u7684\u6570\u636e", (Object[])new Object[0]);
        this.consumerRepository.updateBlacklistStatusByIds(ids, null, this.loginUserService.getLoginAccountName(), EnableStatusEnum.DISABLE);
        if (!CollectionUtils.isEmpty(this.consumerEventListeners)) {
            List<Consumer> terminals = this.consumerRepository.findByIds(ids);
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(terminals, Consumer.class, ConsumerVo.class, HashSet.class, ArrayList.class, new String[0]);
            for (ConsumerEventListener event : this.consumerEventListeners) {
                event.onDisable(voList);
            }
        }
    }

    private void createValidation(Consumer consumer) {
        Validate.notNull((Object)((Object)consumer), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)consumer.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u524d\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        consumer.setId(null);
        Validate.notBlank((CharSequence)consumer.getExternalId(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5206\u5229\u6d88\u8d39\u8005\u5916\u90e8ID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)consumer.getProvinceName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u7701\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)consumer.getCityName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5e02\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)consumer.getDistrictName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u533a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)consumer.getTerminalCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((consumer.getExternalId() == null || consumer.getExternalId().length() < 255 ? 1 : 0) != 0, (String)"\u5206\u5229\u6d88\u8d39\u8005\u5916\u90e8ID\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((consumer.getPhone() == null || consumer.getPhone().length() < 64 ? 1 : 0) != 0, (String)"\u624b\u673a\u53f7\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((consumer.getProvinceCode() == null || consumer.getProvinceCode().length() < 32 ? 1 : 0) != 0, (String)"\u7701\u7f16\u7801\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((consumer.getProvinceName() == null || consumer.getProvinceName().length() < 32 ? 1 : 0) != 0, (String)"\u7701\u540d\u79f0\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((consumer.getCityCode() == null || consumer.getCityCode().length() < 32 ? 1 : 0) != 0, (String)"\u5e02\u7f16\u7801\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((consumer.getCityName() == null || consumer.getCityName().length() < 32 ? 1 : 0) != 0, (String)"\u5e02\u540d\u79f0\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((consumer.getDistrictCode() == null || consumer.getDistrictCode().length() < 32 ? 1 : 0) != 0, (String)"\u533a\u7f16\u7801\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((consumer.getDistrictName() == null || consumer.getDistrictName().length() < 32 ? 1 : 0) != 0, (String)"\u533a\u540d\u79f0\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((consumer.getConsumerAddress() == null || consumer.getConsumerAddress().length() < 128 ? 1 : 0) != 0, (String)"\u6d88\u8d39\u8005\u5730\u5740\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }
}

