/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.consumer.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.consumer.local.entity.Consumer;
import com.biz.crm.cps.business.consumer.local.service.ConsumerService;
import com.biz.crm.cps.business.consumer.sdk.dto.ConsumerDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5206\u5229\u6d88\u8d39\u8005\u4fe1\u606f"})
@RestController
@RequestMapping(value={"/v1/consumer/consumer"})
public class ConsumerController {
    private static final Logger log = LoggerFactory.getLogger(ConsumerController.class);
    @Resource
    private ConsumerService consumerService;

    @ApiOperation(value="\u53ea\u662f\uff08\u5206\u9875\uff09\u67e5\u8be2\u5206\u5229\u6d88\u8d39\u8005\u7684\u57fa\u672c\u4fe1\u606f, \u67e5\u8be2\u6d88\u8d39\u8005\u6570\u636e\u65f6\uff0c\u65e0\u8981\u6c42\uff1b\u67e5\u8be2\u9ed1\u540d\u5355\u6570\u636e\u65f6\uff0c\u9700\u8981\u8d4b\u503cconsumer.blacklistStatus = '009'")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<Consumer>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="consumer", value="\u5206\u5229\u6d88\u8d39\u8005\u5bf9\u8c61") ConsumerDto dto) {
        try {
            Page<Consumer> listByPage = this.consumerService.findByConditions(pageable, dto);
            return Result.ok(listByPage);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u76f8\u5173\u7684\u521b\u5efa\u8fc7\u7a0b\uff0chttp\u63a5\u53e3\u3002\u8bf7\u6ce8\u610f\u8be5\u521b\u5efa\u8fc7\u7a0b\u9664\u4e86\u53ef\u4ee5\u521b\u5efaconsumer\u4e2d\u7684\u57fa\u672c\u4fe1\u606f\u4ee5\u5916\uff0c\u8fd8\u53ef\u4ee5\u5bf9consumer\u4e2d\u5c5e\u4e8eOneToMany\u5173\u8054\u7684\u660e\u7ec6\u4fe1\u606f\u4e00\u540c\u8fdb\u884c\u521b\u5efa\u6ce8\u610f\uff1a\u57fa\u4e8e\uff08Consumer\uff09\u6a21\u578b\u7684\u521b\u5efa\u64cd\u4f5c\u4f20\u5165\u7684consumerJSON\u5bf9\u8c61\uff0c\u5176\u4e3b\u952e\u4fe1\u606f\u4e0d\u80fd\u6709\u503c\uff0c\u670d\u52a1\u7aef\u5c06\u4f1a\u81ea\u52a8\u4e3a\u5176\u8d4b\u4e88\u76f8\u5173\u503c\u3002\u53e6\u5916\uff0c\u521b\u5efa\u64cd\u4f5c\u6210\u529f\u540e\uff0c\u7cfb\u7edf\u5c06\u8fd4\u56de\u8be5\u5bf9\u8c61\u7684\u57fa\u672c\u4fe1\u606f\uff08\u4e0d\u5305\u62ec\u4efb\u4f55\u5173\u8054\u4fe1\u606f\uff09")
    @PostMapping
    public Result<Consumer> create(@RequestBody @ApiParam(name="consumer", value="\u76f8\u5173\u7684\u521b\u5efa\u8fc7\u7a0b\uff0chttp\u63a5\u53e3\u3002\u8bf7\u6ce8\u610f\u8be5\u521b\u5efa\u8fc7\u7a0b\u9664\u4e86\u53ef\u4ee5\u521b\u5efaconsumer\u4e2d\u7684\u57fa\u672c\u4fe1\u606f\u4ee5\u5916\uff0c\u8fd8\u53ef\u4ee5\u5bf9consumer\u4e2d\u5c5e\u4e8eOneToMany\u5173\u8054\u7684\u660e\u7ec6\u4fe1\u606f\u4e00\u540c\u8fdb\u884c\u521b\u5efa\u6ce8\u610f\uff1a\u57fa\u4e8e\uff08Consumer\uff09\u6a21\u578b\u7684\u521b\u5efa\u64cd\u4f5c\u4f20\u5165\u7684consumerJSON\u5bf9\u8c61\uff0c\u5176\u4e3b\u952e\u4fe1\u606f\u4e0d\u80fd\u6709\u503c\uff0c\u670d\u52a1\u7aef\u5c06\u4f1a\u81ea\u52a8\u4e3a\u5176\u8d4b\u4e88\u76f8\u5173\u503c\u3002\u53e6\u5916\uff0c\u521b\u5efa\u64cd\u4f5c\u6210\u529f\u540e\uff0c\u7cfb\u7edf\u5c06\u8fd4\u56de\u8be5\u5bf9\u8c61\u7684\u57fa\u672c\u4fe1\u606f\uff08\u4e0d\u5305\u62ec\u4efb\u4f55\u5173\u8054\u4fe1\u606f\uff09") Consumer consumer) {
        try {
            Consumer current = this.consumerService.create(consumer);
            return Result.ok((Object)((Object)current));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u5206\u5229\u6d88\u8d39\u8005\u4e3b\u952eID\uff0c\u67e5\u8be2\u6210\u529f\u540e\u8fd4\u56de\u5206\u5229\u6d88\u8d39\u8005\u7684\u57fa\u672c\u4fe1\u606f\u3001\u6807\u7b7e\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public Result<Consumer> findDetailsById(@PathVariable @ApiParam(name="id", value="\u5206\u5229\u6d88\u8d39\u8005\u4e3b\u952eID") String id) {
        try {
            Consumer consumer = this.consumerService.findDetailsById(id);
            return Result.ok((Object)((Object)consumer));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u5206\u5229\u6d88\u8d39\u8005\u7f16\u7801\uff0c\u67e5\u8be2\u6210\u529f\u540e\u8fd4\u56de\u5206\u5229\u6d88\u8d39\u8005\u7684\u57fa\u672c\u4fe1\u606f\u3001\u6807\u7b7e\u4fe1\u606f")
    @GetMapping(value={"findDetailsByExternalId"})
    public Result<Consumer> findDetailsByExternalId(@RequestParam @ApiParam(name="externalId", value="\u5206\u5229\u6d88\u8d39\u8005\u7f16\u7801") String externalId) {
        try {
            Consumer consumer = this.consumerService.findDetailsByExternalId(externalId);
            return Result.ok((Object)((Object)consumer));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u79fb\u9664\u9ed1\u540d\u5355(\u5355\u4e2a\u6216\u6279\u91cf)")
    @PatchMapping(value={"/disable"})
    public Result<?> disable(@RequestBody @ApiParam(name="ids", value="string\u6570\u7ec4\u7c7b\u578b\u7684\u4e3b\u952e") List<String> ids) {
        try {
            this.consumerService.disable(ids);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u52a0\u5165\u9ed1\u540d\u5355(\u5355\u4e2a\u6216\u6279\u91cf)")
    @PatchMapping(value={"/enable"})
    public Result<?> enable(@RequestParam @ApiParam(name="ids", value="string\u6570\u7ec4\u7c7b\u578b\u7684\u4e3b\u952e") List<String> ids, @RequestParam @ApiParam(name="blacklistReason", value="\u52a0\u5165\u9ed1\u540d\u5355\u539f\u56e0") String blacklistReason) {
        try {
            this.consumerService.enable(ids, blacklistReason);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

