/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.consumer.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.consumer.local.service.ConsumerIntegralService;
import com.biz.crm.cps.business.consumer.sdk.dto.ConsumerAddIntegralDto;
import com.biz.crm.cps.business.consumer.sdk.dto.ConsumerIntegralRecordDto;
import com.biz.crm.cps.business.consumer.sdk.vo.ConsumerIntegralRecordVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5206\u5229\u6d88\u8d39\u8005\u79ef\u5206\u76f8\u5173"})
@RestController
@RequestMapping(value={"/v1/consumer/integral"})
public class ConsumerIntegralController {
    private static final Logger log = LoggerFactory.getLogger(ConsumerIntegralController.class);
    @Autowired
    private ConsumerIntegralService consumerIntegralService;

    @ApiOperation(value="\u79ef\u5206\u660e\u7ec6")
    @GetMapping(value={"/findRecordByConsumer"})
    public Result<Page<ConsumerIntegralRecordVo>> findRecord(@PageableDefault(value=50) Pageable pageable, @ApiParam(name="consumer", value="\u5206\u5229\u6d88\u8d39\u8005\u5bf9\u8c61") ConsumerIntegralRecordDto dto) {
        try {
            Page<ConsumerIntegralRecordVo> page = this.consumerIntegralService.findRecord(pageable, dto);
            return Result.ok(page);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u79ef\u5206\u4f59\u989d")
    @GetMapping(value={"/findConsumerIntegral"})
    public Result<?> findConsumerIntegral() {
        try {
            String integral = this.consumerIntegralService.findConsumerIntegral();
            return Result.ok((Object)integral);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u79ef\u5206\u589e\u52a0")
    @PostMapping(value={"/consumerAddIntegral"})
    public Result<?> consumerAddIntegral(@RequestBody ConsumerAddIntegralDto dto) {
        try {
            this.consumerIntegralService.consumerAddIntegral(dto);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

