/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.consumer.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.common.sdk.vo.LoginUserDetails;
import com.biz.crm.cps.business.consumer.local.repository.ConsumerRepository;
import com.biz.crm.cps.business.consumer.local.service.ConsumerIntegralService;
import com.biz.crm.cps.business.consumer.sdk.dto.ConsumerAddIntegralDto;
import com.biz.crm.cps.business.consumer.sdk.dto.ConsumerIntegralRecordDto;
import com.biz.crm.cps.business.consumer.sdk.vo.ConsumerIntegralRecordVo;
import com.biz.crm.cps.external.feign.service.CpsTjFeign;
import com.biz.crm.nebular.tj.req.ChangeConsumerPointsDto;
import com.biz.crm.nebular.tj.req.ConsumerPointsChangeRecordsDto;
import com.biz.crm.nebular.tj.req.ConsumerPointsDto;
import com.biz.crm.nebular.tj.res.ConsumerChangeRecords;
import com.biz.crm.nebular.tj.res.ConsumerPointsChangeRecordsVo;
import com.biz.crm.nebular.tj.res.ConsumerPointsVo;
import com.biz.crm.nebular.tj.res.TjResultVo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ConsumerIntegralServiceImpl
implements ConsumerIntegralService {
    private static final Logger log = LoggerFactory.getLogger(ConsumerIntegralServiceImpl.class);
    @Autowired
    private ConsumerRepository consumerRepository;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private CpsTjFeign cpsTjFeign;

    @Override
    public Page<ConsumerIntegralRecordVo> findRecord(Pageable pageable, ConsumerIntegralRecordDto dto) {
        LoginUserDetails loginUserDetails = this.loginUserService.getLoginUser();
        if (Objects.isNull(loginUserDetails)) {
            throw new IllegalArgumentException("\u672a\u83b7\u53d6\u5230\u7528\u6237\u767b\u5f55\u4fe1\u606f\uff01");
        }
        String openId = loginUserDetails.getOpenId();
        if (StringUtils.isBlank((CharSequence)openId)) {
            throw new IllegalArgumentException("\u672a\u83b7\u53d6\u5230openid");
        }
        ConsumerPointsChangeRecordsDto req = new ConsumerPointsChangeRecordsDto();
        req.setLimit(Integer.valueOf(pageable.getPageSize()));
        req.setPage(Integer.valueOf(pageable.getPageNumber()));
        req.setOpenid(openId);
        if (StringUtils.isNotBlank((CharSequence)dto.getType())) {
            req.setType(Integer.valueOf(dto.getType()));
        } else {
            req.setType(Integer.valueOf(3));
        }
        log.info("\u67e5\u8be2\u6d88\u8d39\u8005\u79ef\u5206\u660e\u7ec6\u5165\u53c2={}", (Object)JSONObject.toJSONString((Object)req));
        TjResultVo result = this.cpsTjFeign.consumerPointsChangeRecords(req);
        log.info("\u67e5\u8be2\u6d88\u8d39\u8005\u79ef\u5206\u660e\u7ec6\u8fd4\u56de={}", (Object)JSONObject.toJSONString((Object)result));
        ArrayList vos = Lists.newArrayList();
        if (Objects.nonNull(result) && result.getSuccess().booleanValue()) {
            if (!CollectionUtils.isEmpty((Collection)((ConsumerPointsChangeRecordsVo)result.getData()).getRecords())) {
                for (ConsumerChangeRecords records : ((ConsumerPointsChangeRecordsVo)result.getData()).getRecords()) {
                    ConsumerIntegralRecordVo vo = new ConsumerIntegralRecordVo();
                    vo.setPoints(records.getPoints());
                    vo.setReason(records.getReason());
                    vo.setTm(records.getTm());
                    vo.setType(records.getType().toString());
                    vos.add(vo);
                }
            }
        } else {
            throw new IllegalArgumentException("\u79ef\u5206\u660e\u7ec6\u8bb0\u5f55\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        Page page = new Page();
        page.setRecords((List)vos);
        return page;
    }

    @Override
    public String findConsumerIntegral() {
        LoginUserDetails loginUserDetails = this.loginUserService.getLoginUser();
        if (Objects.isNull(loginUserDetails)) {
            throw new IllegalArgumentException("\u672a\u83b7\u53d6\u5230\u7528\u6237\u767b\u5f55\u4fe1\u606f\uff01");
        }
        String openId = loginUserDetails.getOpenId();
        if (StringUtils.isBlank((CharSequence)openId)) {
            throw new IllegalArgumentException("\u672a\u83b7\u53d6\u5230openid");
        }
        ConsumerPointsDto req = new ConsumerPointsDto();
        req.setOpenid(openId);
        log.info("\u67e5\u8be2\u6d88\u8d39\u8005\u79ef\u5206\u4f59\u989d\u5165\u53c2={}", (Object)JSONObject.toJSONString((Object)req));
        TjResultVo result = this.cpsTjFeign.consumerPoints(req);
        log.info("\u67e5\u8be2\u6d88\u8d39\u8005\u79ef\u5206\u4f59\u989d\u8fd4\u56de={}", (Object)JSONObject.toJSONString((Object)result));
        ArrayList vos = Lists.newArrayList();
        if (Objects.nonNull(result) && result.getSuccess().booleanValue()) {
            return ((ConsumerPointsVo)result.getData()).getPoints();
        }
        throw new IllegalArgumentException("\u79ef\u5206\u4f59\u989d\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
    }

    @Override
    public void consumerAddIntegral(ConsumerAddIntegralDto dto) {
        if (Objects.isNull(dto.getPoints()) && dto.getPoints() <= 0) {
            throw new IllegalArgumentException("\u79ef\u5206\u4f59\u989d\u9519\u8bef\uff01");
        }
        LoginUserDetails loginUserDetails = this.loginUserService.getLoginUser();
        if (Objects.isNull(loginUserDetails)) {
            throw new IllegalArgumentException("\u672a\u83b7\u53d6\u5230\u7528\u6237\u767b\u5f55\u4fe1\u606f\uff01");
        }
        String openId = loginUserDetails.getOpenId();
        if (StringUtils.isBlank((CharSequence)openId)) {
            throw new IllegalArgumentException("\u672a\u83b7\u53d6\u5230openid");
        }
        ChangeConsumerPointsDto req = new ChangeConsumerPointsDto();
        req.setNum(dto.getPoints());
        req.setOpenid(openId);
        req.setReason(dto.getReason());
        req.setType(Integer.valueOf(1));
        log.info("\u6d88\u8d39\u8005\u79ef\u5206\u589e\u52a0\u5165\u53c2={}", (Object)JSONObject.toJSONString((Object)req));
        TjResultVo result = this.cpsTjFeign.changeConsumerPoints(req);
        log.info("\u6d88\u8d39\u8005\u79ef\u5206\u589e\u52a0\u8fd4\u56de={}", (Object)JSONObject.toJSONString((Object)result));
        ArrayList vos = Lists.newArrayList();
        if (Objects.isNull(result) || !result.getSuccess().booleanValue()) {
            throw new IllegalArgumentException("\u79ef\u5206\u589e\u52a0\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
    }
}

