/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.consumer.local.service.notifier;

import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.consumer.local.entity.Consumer;
import com.biz.crm.cps.business.consumer.local.entity.ConsumerTerminalMapping;
import com.biz.crm.cps.business.consumer.local.service.ConsumerService;
import com.biz.crm.cps.business.consumer.local.service.ConsumerTerminalMappingService;
import com.biz.crm.cps.external.barcode.sdk.dto.ConsumerScanCodeDto;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordEventDto;
import com.biz.crm.cps.external.barcode.sdk.event.ConsumerScanCodeRecordEventListener;
import com.bizunited.platform.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Component
public class ConsumerScanCodeRecordEventListenerImpl
implements ConsumerScanCodeRecordEventListener {
    @Autowired
    private ConsumerService consumerService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private ConsumerTerminalMappingService consumerTerminalMappingService;
    @Autowired
    private RocketMQTemplate rocketMQTemplate;

    public void onSuccessScan(ScanCodeRecordEventDto dto) {
        Validate.notNull((Object)dto, (String)"\u626b\u7801\u4e8b\u4ef6\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ConsumerScanCodeDto consumerScanCodeDto = dto.getConsumerScanCodeDto();
        Validate.notNull((Object)consumerScanCodeDto, (String)"\u626b\u7801\u4e8b\u4ef6\u6d88\u8d39\u8005\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Consumer consumer = this.consumerService.findDetailsByExternalId(consumerScanCodeDto.getExternalId());
        if (Objects.nonNull((Object)consumer)) {
            Validate.isTrue((!EnableStatusEnum.ENABLE.equals((Object)consumer.getBlacklistStatus()) ? 1 : 0) != 0, (String)"\u6d88\u8d39\u8005\u626b\u7801\u65f6\uff0c\u5f53\u524d\u6d88\u8d39\u8005\u5df2\u52a0\u5165\u9ed1\u540d\u5355\uff01", (Object[])new Object[0]);
            ConsumerTerminalMapping consumerTerminalMapping = new ConsumerTerminalMapping();
            consumerTerminalMapping.setConsumerId(consumer.getId());
            consumerTerminalMapping.setTerminalCode(consumerScanCodeDto.getBarCodeParticipatorCode());
            ConsumerTerminalMapping mapping = this.consumerTerminalMappingService.findByConsumerTerminalMapping(consumerTerminalMapping);
            if (Objects.isNull((Object)mapping) && StringUtils.isNotBlank((CharSequence)consumerScanCodeDto.getBarCodeParticipatorCode())) {
                this.consumerTerminalMappingService.create(consumerTerminalMapping);
            }
        } else {
            Consumer newConsumer = (Consumer)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)consumerScanCodeDto, Consumer.class, null, null, new String[0]));
            newConsumer.setTerminalCode(consumerScanCodeDto.getBarCodeParticipatorCode());
            newConsumer.setConsumerAddress(dto.getAddress());
            newConsumer.setProvinceCode(dto.getProvinceName());
            newConsumer.setProvinceName(dto.getProvinceName());
            newConsumer.setCityName(dto.getCityName());
            newConsumer.setCityCode(dto.getCityName());
            newConsumer.setDistrictName(dto.getDistrictName());
            newConsumer.setDistrictCode(dto.getDistrictName());
            newConsumer.setAuthorizeTime(new Date());
            newConsumer.setOpenId(newConsumer.getExternalId());
            if (StringUtils.isNotBlank((CharSequence)newConsumer.getOpenId())) {
                newConsumer.setConsumerCode(newConsumer.getOpenId());
            }
            this.consumerService.create(newConsumer);
            final ArrayList<String> openIds = new ArrayList<String>();
            openIds.add(newConsumer.getOpenId());
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                public void afterCommit() {
                    ConsumerScanCodeRecordEventListenerImpl.this.rocketMQTemplate.syncSendOrderly("CUSOMER_2_TIANJIAN_TOPIC", MessageBuilder.withPayload((Object)openIds).build(), "CUSOMER_2_TIANJIAN_TOPIC");
                }
            });
        }
    }

    public void onFailScan(ScanCodeRecordEventDto dto) {
    }
}

