package com.biz.crm.cps.business.consumer.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * 消费者数量查询Dto
 * @Author dy
 * @DATE 2022/4/1
 **/
@Data
@ApiModel("消费者数量查询Dto")
public class ConsumerCountDto implements Serializable {

  private static final long serialVersionUID = 2979883786327294810L;

  @ApiModelProperty("终端编码")
  private String terminalCode;


  @ApiModelProperty("消费者关联关系创建开始时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date consumerRelevanceCreateStartDate;


  @ApiModelProperty("消费者关联关系创建结束时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date consumerRelevanceCreateEndDate;
}

