package com.biz.crm.cps.business.consumer.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * 分利消费者信息查询dto
 * @author songjingen
 */
@Data
@ApiModel(value = "ConsumerDto", description = "分利消费者信息查询dto")
public class ConsumerDto implements Serializable {

  /**
   * 
   */
  private static final long serialVersionUID = 8431016043153095425L;

  /**
   * 消费者外部id
   */
  @ApiModelProperty("消费者外部id")
  private String externalId;

  /**
   * 手机号
   */
  @ApiModelProperty("手机号")
  private String phone;

  /**
   * 姓名
   */
  @ApiModelProperty("姓名")
  private String fullName;

  /**
   * 昵称
   */
  @ApiModelProperty("昵称")
  private String nickname;

  /**
   * 手机号授权时间开始
   */
  @ApiModelProperty("授权时间开始")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date authorizeTimeStart;

  /**
   * 手机号授权时间结束
   */
  @ApiModelProperty("授权时间结束")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date authorizeTimeEnd;

  /**
   * 消费者标签
   */
  @ApiModelProperty("消费者标签")
  private String tagName;

  /**
   * 消费者黑名单状态
   */
  @ApiModelProperty("消费者黑名单状态")
  private String blacklistStatus;

  /**
   * 创建时间开始
   */
  @ApiModelProperty("创建时间开始")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTimeStart;

  /**
   * 创建时间结束
   */
  @ApiModelProperty("创建时间结束")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTimeEnd;

  /**
   * 关联终端编码
   */
  @ApiModelProperty("关联终端编码")
  private String terminalCode;

  /**
   * 关键字
   */
  @ApiModelProperty("关键字 姓名/电话")
  private String keyword;
}
