package com.biz.crm.cps.business.consumer.sdk.service;

import com.biz.crm.cps.business.consumer.sdk.dto.ConsumerCountDto;
import com.biz.crm.cps.business.consumer.sdk.vo.ConsumerVo;

import java.util.List;

/**
 * 消费者voService
 * @author songjingen
 */
public interface ConsumerVoService {

  /**
   * 通过消费者外部id获取对象
   * @param externalId
   * @return
   */
  ConsumerVo findByExternalId(String externalId);

  /**
   * 通过编码查询
   * @param consumerCode
   * @return
   */
  ConsumerVo findByConsumerCode(String consumerCode);

  /**
   * 查询终端下所有的消费者
   */
  List<ConsumerVo> findByTerminalCode(String terminalCode);

  /**
   * 多条件查询消费者数量
   * @param dto
   * @return
   */
  Integer countByConsumerCountDto(ConsumerCountDto dto);
}
