/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.cost.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.cost.local.entity.CostDealerBillDetailEntity;
import com.biz.crm.cps.business.cost.local.entity.CostDealerBillEntity;
import com.biz.crm.cps.business.cost.local.repository.CostDealerBillRepository;
import com.biz.crm.cps.business.cost.local.service.CostDealerBillDetailService;
import com.biz.crm.cps.business.cost.local.service.CostDealerBillService;
import com.biz.crm.cps.business.cost.sdk.dto.CostDealerBillDto;
import com.biz.crm.cps.business.participator.sdk.service.DealerVoService;
import com.biz.crm.cps.business.participator.sdk.vo.DealerVo;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class CostDealerBillServiceImpl
implements CostDealerBillService {
    private static final Logger log = LoggerFactory.getLogger(CostDealerBillServiceImpl.class);
    @Autowired
    private CostDealerBillRepository costDealerBillRepository;
    @Autowired
    private CostDealerBillDetailService costDealerBillDetailService;
    @Autowired
    private DealerVoService dealerVoService;

    @Override
    public Page<CostDealerBillEntity> findByConditions(CostDealerBillDto costDealerBillDto, Pageable pageable) {
        if (costDealerBillDto == null) {
            return new Page();
        }
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        costDealerBillDto.setTenantCode(TenantUtils.getTenantCode());
        return this.costDealerBillRepository.findByConditions(costDealerBillDto, pageable);
    }

    @Override
    public CostDealerBillEntity create(CostDealerBillEntity dealerBill) {
        this.validateCreate(dealerBill);
        this.costDealerBillRepository.save((Object)dealerBill);
        Set<CostDealerBillDetailEntity> billDetail = dealerBill.getBillDetail();
        if (!CollectionUtils.isEmpty(billDetail)) {
            billDetail.stream().forEach(item -> item.setCostDealerBillId(dealerBill.getId()));
            this.costDealerBillDetailService.createBatch(billDetail);
        }
        return dealerBill;
    }

    private void validateCreate(CostDealerBillEntity dealerBill) {
        Validate.notNull((Object)((Object)dealerBill), (String)"\u521b\u5efa\u65f6\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dealerBill.getDealerCode(), (String)"\u7ecf\u9500\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DealerVo dealer = this.dealerVoService.findByCustomerCode(dealerBill.getDealerCode());
        Validate.notNull((Object)dealer, (String)"\u7ecf\u9500\u5546\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dealerBill.getChannel(), (String)"\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dealerBill.getOrgCode(), (String)"\u6240\u5c5e\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dealerBill.getSourceCode(), (String)"\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((dealerBill.getDealerCode() == null || dealerBill.getDealerCode().length() < 128 ? 1 : 0) != 0, (String)"\u7ecf\u9500\u5546\u7f16\u7801,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dealerBill.getChannel() == null || dealerBill.getChannel().length() < 64 ? 1 : 0) != 0, (String)"\u6e20\u9053\u7f16\u7801,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dealerBill.getOrgCode() == null || dealerBill.getOrgCode().length() < 128 ? 1 : 0) != 0, (String)"\u6240\u5c5e\u7ec4\u7ec7\u7f16\u7801,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dealerBill.getSourceCode() == null || dealerBill.getSourceCode().length() < 128 ? 1 : 0) != 0, (String)"\u6765\u6e90\u7f16\u7801,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }
}

