package com.biz.crm.cps.business.customerservice.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.customerservice.local.entity.Feedback;
import com.biz.crm.cps.business.customerservice.local.service.FeedbackService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

/**
 * @author zwk
 * @date 2021/9/26
 * @description TODO
 **/
@RestController
@RequestMapping("v1/customer/feedback")
@Api(tags = "意见反馈")
public class FeedBackController {

    private final FeedbackService service;

    public FeedBackController(FeedbackService service) {
        this.service = service;
    }

    @PostMapping
    @ApiOperation(value = "新增意见反馈")
    public Result<?> create(@RequestBody Feedback feedback){
        service.create(feedback);
        return Result.ok();
    }

    @GetMapping("findByCondition")
    @ApiOperation(value = "分页查询意见反馈")
    public Result<Page<Feedback>> findByConditions(Pageable pageable, String status){
        return Result.ok(service.findByConditions(pageable,status));
    }

    @GetMapping
    @ApiOperation(value = "查询意见反馈详情")
    public Result<Feedback> findById(String id){
        return Result.ok(service.findById(id));
    }

    @PatchMapping
    @ApiOperation(value = "处理意见反馈")
    public Result<?> handle(@RequestBody Feedback feedback){
        service.update(feedback);
        return Result.ok();
    }

}
