package com.biz.crm.cps.business.customerservice.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.customerservice.sdk.common.dto.FeedBackDto;
import com.biz.crm.cps.business.customerservice.sdk.common.service.FeedBackVoService;
import com.biz.crm.cps.business.customerservice.sdk.common.vo.FeedBackVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * web意见反馈
 * @author zxw
 * @date 2021/10/08
 * @description
 **/
@RestController
@RequestMapping("v1/customer/feedback")
@Api(tags = "web意见反馈")
@Slf4j
public class FeedBackVoController {

  @Autowired
  private FeedBackVoService feedbackVoService;

  /**
   * 分页查询意见反馈
   * @param pageable
   * @param feedbackDto
   * @return
   */
  @GetMapping("findByConditions")
  @ApiOperation(value = "分页查询意见反馈")
  public Result<Page<FeedBackVo>> findByConditions(Pageable pageable, FeedBackDto feedbackDto){
    try {
      Page<FeedBackVo> page = feedbackVoService.findByConditions(pageable, feedbackDto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 查询详情(包括终端信息)
   * @param id
   * @return
   */
  @GetMapping("findDetailById")
  @ApiOperation(value = "查询详情(包括终端信息)")
  public Result<FeedBackVo> findDetailById(@RequestParam("id") String id){
    try {
      FeedBackVo vo = feedbackVoService.findDetailById(id);
      return Result.ok(vo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
