package com.biz.crm.cps.business.customerservice.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;

/**
 * @author hecheng
 * @description: 意见反馈
 * @date 2021/9/14 下午5:09
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "feedback", description = "意见反馈")
@TableName("customerservice_feedback")
public class Feedback extends TenantFlagOpEntity {

  /**
   * 物料编码
   *
   * @Column(name = "feedback_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 意见反馈编码 '")
   */
  @ApiModelProperty("意见反馈编码")
  @TableField(value = "feedback_code")
  private String feedbackCode;

  /**
   * 参与者类型 1-经销商，2-终端，3-消费者
   */
  @ApiModelProperty("参与者类型")
  @TableField(value = "participator_type")
  private String participatorType;

  /**
   * 参与者编码
   */
  @ApiModelProperty("参与者编码")
  @TableField(value = "participator_code")
  private String participatorCode;

  /**
   * 参与者名称
   */
  @ApiModelProperty("参与者名称")
  @TableField(value = "participator_name")
  private String participatorName;
  /**
   * 意见反馈主题
   *
   * @Column(name = "title", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 意见反馈主题 '")
   */
  @ApiModelProperty("意见反馈主题")
  @TableField(value = "title")
  private String title;
  /**
   * 处理状态
   *
   * @Column(name = "handle_status", nullable = false, length = 10, columnDefinition = "VARCHAR(10) COMMENT ' 处理状态 '")
   */
  @ApiModelProperty("处理状态")
  @TableField(value = "handle_status")
  private String handleStatus;
  /**
   * 处理时间
   *
   * @Column(name = "review_date", nullable = true, columnDefinition = "datetime COMMENT ' 处理时间 '")
   */
  @ApiModelProperty("处理时间")
  @TableField(value = "review_date")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
  private Date reviewDate;
  /**
   * 意见反馈主描述
   *
   * @Column(name = "description", nullable = false, length = 5000, columnDefinition = "VARCHAR(5000) COMMENT ' 意见反馈描述'")
   */
  @ApiModelProperty("意见反馈描述")
  @TableField(value = "description")
  private String description;

  /**
   * 反馈图片最多三张用逗号隔开
   *
   * @Column(name = "picture_addresses", nullable = false, length = 500, columnDefinition = "VARCHAR(500) COMMENT ' 反馈图片'")
   */
  @ApiModelProperty("反馈图片")
  @TableField(value = "picture_addresses")
  private String pictureAddresses;

  /**
   * 意见反馈图
   */
  @ApiModelProperty("意见反馈图")
  @TableField(exist = false)
  private String[] pictureAddressList;

  public void setPictureAddresses(String pictureAddresses) {
    this.pictureAddresses = pictureAddresses;
    if (StringUtils.isNotBlank(pictureAddresses)) {
      this.pictureAddressList = pictureAddresses.split(",");
    }
  }
}
