package com.biz.crm.cps.business.customerservice.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * @ClassName: FeedbackMedia
 * @Author: hecheng
 * @Description: 反馈意见照片
 * @Version: 1.0
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@TableName("customerservice_feedback_media")
@Api(tags = "反馈意见照片")
public class FeedbackMedia extends UuidFlagOpEntity {

  /**
   * 物料编码
   *
   * @Column(name = "feedback_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 意见反馈编码 '")
   */
  @ApiModelProperty("意见反馈编码")
  @TableField(value = "feedback_code")
  private String feedbackCode;
  /**
   * 图片地址
   *
   * @Column(name = "url_address", nullable = false, length = 255, columnDefinition = "VARCHAR(255) COMMENT ' 图片地址 '")
   */
  @TableField(value = "url_address")
  private String urlAddress;
  /**
   * 排序位置
   *
   * @Column(name = "range_num", nullable = false, length = 2, columnDefinition = "int(2) COMMENT ' 排序位置 '")
   */
  @TableField(value = "range_num")
  private Integer rangeNum;
  /**
   * 文件名称
   *
   * @Column(name = "file_name", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 文件名称 '")
   */
  @TableField(value = "file_name")
  private String fileName;

  /**
   * 源文件名称
   *
   * @Column(name = "original_file_name", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 源文件名称 '")
   */
  @TableField(value = "original_file_name")
  private String originalFileName;

  /**
   * 地址
   *
   * @Column(name = "relative_local", nullable = false, length = 255, columnDefinition = "VARCHAR(255) COMMENT ' 地址 '")
   */
  @TableField(value = "relative_local")
  private String relativeLocal;

}
