package com.biz.crm.cps.business.customerservice.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.customerservice.local.mapper.FeedBackVoMapper;
import com.biz.crm.cps.business.customerservice.sdk.common.dto.FeedBackDto;
import com.biz.crm.cps.business.customerservice.sdk.common.vo.FeedBackVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * web意见反馈持久化
 * @Author: zengxingwang
 * @Date: 2021/10/8 10:34
 */
@Component
public class FeedBackVoRepository {

  @Autowired
  private FeedBackVoMapper feedBackVoMapper;

  /**
   * 分页查询意见反馈
   * @param pageable
   * @param feedbackDto
   * @return
   */
  public Page<FeedBackVo> findByConditions(Pageable pageable, FeedBackDto feedbackDto) {
    Page<FeedBackVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return feedBackVoMapper.findByConditions(page, feedbackDto);
  }

  /**
   * 查询详情(包括终端信息)
   * @param id
   * @return
   */
  public FeedBackVo findDetailById(String id) {
    return feedBackVoMapper.findDetailById(id);
  }
}
