package com.biz.crm.cps.business.customerservice.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.customerservice.local.entity.Feedback;
import com.biz.crm.cps.business.customerservice.local.mapper.FeedbackMapper;
import org.springframework.stereotype.Component;

/**
 * 意见反馈 的 数据库访问类 {@link Feedback}
 *
 * @author hecheng
 */
@Component
public class FeedbackRepository extends ServiceImpl<FeedbackMapper, Feedback> {


  /**
   * 通过意见反馈id查询意见反馈详情
   *
   * @param id
   */
  public Feedback findDetailsById(String id) {
    return this.baseMapper.findDetailsById(id);
  }

  /**
   * 通过主键查询陈列政策详情
   *
   * @param id 主键
   * @return 陈列政策
   */
  public Feedback findById(String id) {
    return this.baseMapper.selectById(id);
  }


  /**
   * 根据feedbackCode 意见反馈编码 查询（包括关联表）
   *
   * @param feedbackCode
   * @return
   */
  public Feedback findByFeedbackCode(String feedbackCode) {
    return this.baseMapper.findByFeedbackCode(feedbackCode);
  }
}
