package com.biz.crm.cps.business.customerservice.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.customerservice.local.repository.FeedBackVoRepository;
import com.biz.crm.cps.business.customerservice.sdk.common.dto.FeedBackDto;
import com.biz.crm.cps.business.customerservice.sdk.common.service.FeedBackVoService;
import com.biz.crm.cps.business.customerservice.sdk.common.vo.FeedBackVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/**
 * web意见反馈接口实现
 * @Author: zengxingwang
 * @Date: 2021/10/8 10:28
 */
@Service
public class FeedBackVoServiceImpl implements FeedBackVoService {

  @Autowired
  private FeedBackVoRepository feedBackVoRepository;
  /**
   * 分页查询意见反馈
   * @param pageable
   * @param feedbackDto
   * @return
   */
  @Override
  public Page<FeedBackVo> findByConditions(Pageable pageable, FeedBackDto feedbackDto) {
    if(feedbackDto == null){
      return new Page<>();
    }
    feedbackDto.setTenantCode(TenantUtils.getTenantCode());
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if(feedbackDto.getCreateTime() != null && feedbackDto.getCreateTime().length > 1){
      String[] createTime = feedbackDto.getCreateTime();
      feedbackDto.setCreateTimeStart(createTime[0]);
      feedbackDto.setCreateTimeEnd(createTime[1]);
    }
    if(feedbackDto.getCreateTime() != null && feedbackDto.getReviewDate().length > 1){
      String[] reviewDate = feedbackDto.getReviewDate();
      feedbackDto.setReviewDateStart(reviewDate[0]);
      feedbackDto.setReviewDateEnd(reviewDate[1]);
    }
    return feedBackVoRepository.findByConditions(pageable, feedbackDto);
  }

  /**
   * 查询详情(包括终端信息)
   * @param id
   * @return
   */
  @Override
  public FeedBackVo findDetailById(String id) {
    if(StringUtils.isBlank(id)){
      return null;
    }
    return feedBackVoRepository.findDetailById(id);
  }
}
