package com.biz.crm.cps.business.customerservice.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.customerservice.local.entity.Feedback;
import com.biz.crm.cps.business.customerservice.local.repository.FeedbackRepository;
import com.biz.crm.cps.business.customerservice.local.service.FeedbackService;
import com.biz.crm.cps.business.customerservice.sdk.common.constant.FeedbackCodeConstant;
import com.biz.crm.cps.business.customerservice.sdk.common.enums.FeedbackHandleStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.Date;
import java.util.List;

/**
 * @author hecheng
 * @description: 意见反馈实现
 * @date 2021/9/14 下午6:12
 */
@Service("FeedbackServiceImpl")
public class FeedbackServiceImpl implements FeedbackService {

  @Autowired
  private FeedbackRepository feedbackRepository;
  @Autowired(required = false)
  private GenerateCodeService generateCodeService;
  @Autowired(required = false)
  private LoginUserService loginUserService;
  @Autowired
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Override
  @Transactional
  public Feedback create(Feedback feedback) {
    Feedback current = this.createForm(feedback);
    this.feedbackRepository.save(current);
    return current;
  }

  @Override
  @Transactional
  public Feedback createForm(Feedback feedback) {
    /*
     * 对静态模型的保存操作过程为：
     * 1、如果当前模型对象不是主模型
     *  1.1、那么创建前只会验证基本信息，直接的ManyToOne关联（单选）和ManyToMany关联（多选）
     *  1.2、验证完成后，也只会保存当前对象的基本信息，直接的单选
     *  1.3、ManyToMany的关联（多选），暂时需要开发人员自行处理
     * 2、如果当前模型对象是主业务模型
     *  2.1、创建前会验证当前模型的基本属性，单选和多选属性
     *  2.2、然后还会验证当前模型关联的各个OneToMany明细信息，调用明细对象的服务，明每一条既有明细进行验证
     *  （2.2的步骤还需要注意，如果当前被验证的关联对象是回溯对象，则不需要验证了）
     * 2.3、还会验证当前模型关联的各个OneToOne分组，调用分组对象的服务，对分组中的信息进行验证
     *   2.3.1、包括验证每一个分组项的基本信息、直接的单选、多选信息
     *   2.3.2、以及验证每个分组的OneToMany明细信息
     * */
    Date now = new Date();
    String account = this.loginUserService.getLoginAccountName();
    LoginUserDetailsForCPS user = this.loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
    feedback.setTenantCode(TenantUtils.getTenantCode());
    feedback.setCreateAccount(account);
    feedback.setCreateTime(now);
    feedback.setModifyAccount(account);
    feedback.setModifyTime(now);
    feedback.setParticipatorCode(user.getConsumerCode());
    feedback.setParticipatorName(user.getConsumerName());
    feedback.setParticipatorType("1");
    if (feedback.getPictureAddressList() != null && feedback.getPictureAddressList().length > 0){
      feedback.setPictureAddresses(StringUtils.join(feedback.getPictureAddressList(),","));
    }
    feedback.setHandleStatus(FeedbackHandleStatusEnum.NO_DEAL_WITH.getDictCode());
    feedback.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    feedback.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    if (StringUtils.isBlank(feedback.getFeedbackCode())) {
      feedback.setFeedbackCode(this.generateCodeService.generateCode(FeedbackCodeConstant.FEEDBACK_CODE, 1).get(0));
    }
    this.createValidation(feedback);
    return feedback;
  }

  @Override
  @Transactional
  public Feedback update(Feedback feedback) {
    Feedback current = this.updateForm(feedback);

    return current;
  }

  @Override
  @Transactional
  public Feedback updateForm(Feedback feedback) {
    /*
     * 对静态模型的修改操作的过程为：
     * 1、如果当前模型对象不是主模型
     *  1.1、那么创建前只会验证基本信息，直接的ManyToOne关联（单选）和ManyToMany关联（多选）
     *  1.2、验证完成后，也只会保存当前对象的基本信息，直接的单选
     *  1.3、ManyToMany的关联（多选），暂时需要开发人员自行处理
     *
     * 2、如果当前模型对象是主业务模型
     *  2.1、创建前会验证当前模型的基本属性，单选和多选属性
     *  2.2、然后还会验证当前模型关联的各个OneToMany明细信息，调用明细对象的服务，明每一条既有明细进行验证
     *  （2.2的步骤还需要注意，如果当前被验证的关联对象是回溯对象，则不需要验证了）
     *  2.3、还会验证当前模型关联的各个OneToOne分组，调用分组对象的服务，对分组中的信息进行验证
     *    2.3.1、包括验证每一个分组项的基本信息、直接的单选、多选信息
     *    2.3.2、以及验证每个分组的OneToMany明细信息
     */
    this.updateValidation(feedback);
    Validate.notBlank(feedback.getRemark(),"处理意见不能为空");
    //这里可根据id或者code更新
    String currentId = feedback.getId();
    Feedback current = this.feedbackRepository.getById(currentId);
    current.setHandleStatus(FeedbackHandleStatusEnum.DEAL_WITH.getDictCode());
    current.setRemark(feedback.getRemark());
    current.setReviewDate(new Date());
    // 开始赋值——更新时间与更新人
    Date now = new Date();
    String account = this.loginUserService.getLoginAccountName();
    current.setModifyAccount(account);
    current.setModifyTime(now);
    this.feedbackRepository.saveOrUpdate(current);
    return current;
  }

  @Override
  public Feedback findById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    return feedbackRepository.getById(id);
  }

  @Override
  public Feedback findDetailsById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    return feedbackRepository.findDetailsById(id);
  }

  @Override
  public Feedback findByFeedbackCode(String feedbackCode) {
    if (StringUtils.isBlank(feedbackCode)) {
      return null;
    }
    return feedbackRepository.findByFeedbackCode(feedbackCode);
  }

  /**
   * 在创建一个新的Feedback模型对象之前，检查对象各属性的正确性，其主键属性必须没有值
   */
  private void createValidation(Feedback feedback) {
    Validate.notNull(feedback, "进行当前操作时，信息对象必须传入!!");
    // 判定那些不能为null的输入值：条件为 caninsert = true，且nullable = false
    Validate.isTrue(StringUtils.isBlank(feedback.getId()), "添加信息时，当期信息的数据编号（主键）不能有值！");
    feedback.setId(null);
    Validate.notBlank(feedback.getTenantCode(), "添加信息时，租户编号不能为空！");
    Validate.notBlank(feedback.getParticipatorCode(), "添加信息时，参与者编码不能为空！");
    Validate.notBlank(feedback.getParticipatorType(), "添加信息时，参与者型不能为空！");
    Validate.notBlank(feedback.getParticipatorName(), "添加信息时，参与者名称不能为空！");
    Validate.notBlank(feedback.getTitle(), "添加信息时，意见反馈主题不能为空！");
    Validate.isTrue(feedback.getTitle().length() < 128, "意见反馈主题，在进行添加时填入值超过了限定长度(128)，请检查!");
    Validate.notNull(FeedbackHandleStatusEnum.getByKey(feedback.getHandleStatus()), "添加信息时，处理状态不合法！");
    if (StringUtils.isNotBlank(feedback.getFeedbackCode())) {
      List<Feedback> list = this.feedbackRepository.lambdaQuery()
              .eq(Feedback::getFeedbackCode, feedback.getFeedbackCode())
              .select(Feedback::getId)
              .list();
      Validate.isTrue(CollectionUtils.isEmpty(list), "编码[" + feedback.getFeedbackCode() + "]已存在");
    }
  }

  /**
   * 在修改一个Feedback模型对象之前，检查对象各属性的正确性，其主键属性必须没有值
   */
  private void updateValidation(Feedback feedback) {
    Validate.notNull(feedback, "进行当前操作时，信息对象必须传入!!");
    // 判定那些不能为null的输入值：条件为 caninsert = true，且nullable = false
    Validate.notBlank(feedback.getId(), "修改信息时，当期信息的数据编号（主键）不能为空！");
  }

  @Override
  public Page<Feedback> findByConditions(Pageable pageable, String status) {
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1,10));
    QueryWrapper<Feedback> wrapper = Wrappers.query();
    if (StringUtils.isNotBlank(status)){
      wrapper.eq("handle_status", status).eq("participator_code", loginUserService.getLoginDetails(LoginUserDetailsForCPS.class).getConsumerCode());
    }else {
      wrapper.eq("participator_code", loginUserService.getLoginDetails(LoginUserDetailsForCPS.class).getConsumerCode());
    }
    Page<Feedback> page = new Page<>(pageable.getPageNumber(),pageable.getPageSize());
    feedbackRepository.page(page, wrapper);
    return page;
  }
}
