/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.customerservice.local.service.internal;

import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.cps.business.common.local.entity.BaseIdEntity;
import com.biz.crm.cps.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.cps.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.customerservice.local.entity.Feedback;
import com.biz.crm.cps.business.customerservice.local.repository.FeedbackRepository;
import com.biz.crm.cps.business.customerservice.local.service.FeedbackService;
import com.biz.crm.cps.business.customerservice.sdk.common.enums.FeedbackHandleStatusEnum;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="FeedbackServiceImpl")
public class FeedbackServiceImpl
implements FeedbackService {
    @Autowired
    private FeedbackRepository feedbackRepository;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public Feedback create(Feedback feedback) {
        Feedback current = this.createForm(feedback);
        this.feedbackRepository.save((Object)current);
        return current;
    }

    @Override
    @Transactional
    public Feedback createForm(Feedback feedback) {
        Date now = new Date();
        String account = this.loginUserService.getLoginAccountName();
        feedback.setTenantCode(TenantUtils.getTenantCode());
        feedback.setCreateAccount(account);
        feedback.setCreateTime(now);
        feedback.setModifyAccount(account);
        feedback.setModifyTime(now);
        this.createValidation(feedback);
        feedback.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        feedback.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        if (StringUtils.isBlank((CharSequence)feedback.getFeedbackCode())) {
            feedback.setFeedbackCode((String)this.generateCodeService.generateCode("FK", 1).get(0));
        }
        return feedback;
    }

    @Override
    @Transactional
    public Feedback update(Feedback feedback) {
        Feedback current = this.updateForm(feedback);
        return current;
    }

    @Override
    @Transactional
    public Feedback updateForm(Feedback feedback) {
        this.updateValidation(feedback);
        String currentId = feedback.getId();
        Feedback current = (Feedback)((Object)this.feedbackRepository.getById((Serializable)((Object)currentId)));
        current = (Feedback)((Object)Validate.notNull((Object)((Object)current), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]));
        BeanUtils.copyProperties((Object)((Object)feedback), (Object)((Object)current), (String[])new String[]{"id", "modifyTime", "createAccount", "createTime", "tenantCode"});
        Date now = new Date();
        String account = this.loginUserService.getLoginAccountName();
        current.setModifyAccount(account);
        current.setModifyTime(now);
        this.feedbackRepository.saveOrUpdate((Object)current);
        return current;
    }

    @Override
    public Feedback findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (Feedback)((Object)this.feedbackRepository.getById((Serializable)((Object)id)));
    }

    @Override
    public Feedback findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.feedbackRepository.findDetailsById(id);
    }

    @Override
    public Feedback findByFeedbackCode(String feedbackCode) {
        if (StringUtils.isBlank((CharSequence)feedbackCode)) {
            return null;
        }
        return this.feedbackRepository.findByFeedbackCode(feedbackCode);
    }

    private void createValidation(Feedback feedback) {
        Validate.notNull((Object)((Object)feedback), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)feedback.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        feedback.setId(null);
        Validate.notBlank((CharSequence)feedback.getTenantCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)feedback.getParticipatorCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u53c2\u4e0e\u8005\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)feedback.getParticipatorType(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u53c2\u4e0e\u8005\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)feedback.getParticipatorName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u53c2\u4e0e\u8005\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)feedback.getTitle(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u610f\u89c1\u53cd\u9988\u4e3b\u9898\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((feedback.getTitle().length() < 128 ? 1 : 0) != 0, (String)"\u610f\u89c1\u53cd\u9988\u4e3b\u9898\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.notNull((Object)FeedbackHandleStatusEnum.getByKey((String)feedback.getHandleStatus()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5904\u7406\u72b6\u6001\u4e0d\u5408\u6cd5\uff01", (Object[])new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)feedback.getFeedbackCode())) {
            List list = ((LambdaQueryChainWrapper)this.feedbackRepository.lambdaQuery().eq(Feedback::getFeedbackCode, (Object)feedback.getFeedbackCode())).select(new SFunction[]{BaseIdEntity::getId}).list();
            Validate.isTrue((boolean)CollectionUtils.isEmpty((Collection)list), (String)("\u7f16\u7801[" + feedback.getFeedbackCode() + "]\u5df2\u5b58\u5728"), (Object[])new Object[0]);
        }
    }

    private void updateValidation(Feedback feedback) {
        Validate.notNull((Object)((Object)feedback), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)feedback.getId(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)feedback.getTenantCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)feedback.getParticipatorCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u53c2\u4e0e\u8005\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)feedback.getParticipatorType(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u53c2\u4e0e\u8005\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)feedback.getParticipatorName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u53c2\u4e0e\u8005\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)feedback.getTitle(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u610f\u89c1\u53cd\u9988\u4e3b\u9898\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((feedback.getTitle().length() < 128 ? 1 : 0) != 0, (String)"\u610f\u89c1\u53cd\u9988\u4e3b\u9898\uff0c\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.notNull((Object)FeedbackHandleStatusEnum.getByKey((String)feedback.getHandleStatus()), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5904\u7406\u72b6\u6001\u4e0d\u5408\u6cd5\uff01", (Object[])new Object[0]);
    }
}

