package com.biz.crm.cps.business.customerservice.sdk.common.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * @Description:意见反馈状态
 * @Author: hecheng
 **/
public enum FeedbackHandleStatusEnum {
  /**
   * 待处理
   */
  NO_DEAL_WITH("no_deal_with", "no_deal_with", "待处理","1"),
  /**
   * 已处理s
   */
  DEAL_WITH("deal_with", "deal_with", "已处理","2"),
  /**
   * 处理中
   */
  DEAL_WITH_ING("deal_with_ing", "deal_with_ing", "处理中","3"),;

  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;


  FeedbackHandleStatusEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  /**
   * 通过key获取 FeedbackHandleStatusEnum
   *
   * @param key
   * @return
   */
  public static FeedbackHandleStatusEnum getByKey(String key) {
    return Arrays.stream(FeedbackHandleStatusEnum.values()).filter(item ->Objects.equals(item.getKey(), key))
            .findFirst().orElse(null);
  }
}
