package com.biz.crm.cps.business.customerservice.sdk.common.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 意见反馈vo
 * @Author: zengxingwang
 * @Date: 2021/10/8 10:16
 */
@Data
public class FeedBackVo {

  /**
   * 主键
   */
  @ApiModelProperty("主键")
  private String id;

  /**
   * 意见反馈编码
   */
  @ApiModelProperty("意见反馈编码")
  private String feedbackCode;

  /**
   * 意见反馈主题
   */
  @ApiModelProperty("意见反馈主题")
  private String title;

  /**
   * 处理状态
   */
  @ApiModelProperty("处理状态")
  private String handleStatus;

  /**
   * 备注
   */
  @ApiModelProperty("备注")
  private String remark;

  /**
   * 创建时间
   */
  @ApiModelProperty(name = "createTimeStart", value = "创建时间", required = true)
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  private Date createTime;

  /**
   * 处理时间
   */
  @ApiModelProperty("处理时间")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  private Date reviewDate;

  /**
   * 客户所属组织名称
   */
  @ApiModelProperty("客户所属组织名称")
  private String cusOrgName;

  /**
   * 所属组织名称
   */
  @ApiModelProperty("所属组织名称")
  private String orgName;

  /**
   * 终端门店所属渠道
   */
  @ApiModelProperty("终端门店所属渠道")
  private String channel;

  /**
   * 终端门店类型
   */
  @ApiModelProperty("终端门店类型")
  private String terminalType;

  /**
   * 参与者编码
   */
  @ApiModelProperty("参与者编码")
  private String participatorCode;

  /**
   * 参与者名称
   */
  @ApiModelProperty("参与者名称")
  private String participatorName;

  /**
   * 意见反馈描述
   */
  @ApiModelProperty("意见反馈描述")
  private String description;

  /**
   * 反馈图片
   */
  @ApiModelProperty("反馈图片")
  private String pictureAddresses;
}
