/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.participator.local.service.internal;

import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.participator.local.entity.DealerCommunicationEntity;
import com.biz.crm.cps.business.participator.local.entity.DealerContactPersonEntity;
import com.biz.crm.cps.business.participator.local.entity.DealerEntity;
import com.biz.crm.cps.business.participator.local.repository.DealerRepository;
import com.biz.crm.cps.business.participator.local.service.DealerCommunicationService;
import com.biz.crm.cps.business.participator.local.service.DealerContactPersonsService;
import com.biz.crm.cps.business.participator.local.service.DealerService;
import com.biz.crm.cps.business.participator.sdk.event.DealerEventListener;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"DealerServiceExpandImpl"})
public class DealerServiceImpl
implements DealerService {
    @Autowired
    private DealerRepository dealerRepository;
    @Autowired(required=false)
    private List<DealerEventListener> dealerEventListeners;
    @Autowired
    private DealerContactPersonsService dealerContactPersonsService;
    @Autowired
    private DealerCommunicationService dealerCommunicationService;

    @Override
    @Transactional
    public DealerEntity create(DealerEntity dealer) {
        DealerCommunicationEntity dealerCommunication;
        DealerEntity current = this.createForm(dealer);
        this.dealerRepository.save((Object)current);
        Set<DealerContactPersonEntity> dealerContactPersons = dealer.getDealerContactPersons();
        if (!CollectionUtils.isEmpty(dealerContactPersons)) {
            dealerContactPersons.stream().forEach(item -> item.setDealerId(current.getId()));
            this.dealerContactPersonsService.createBatch(dealerContactPersons);
        }
        if ((dealerCommunication = dealer.getDealerCommunication()) != null) {
            dealerCommunication.setDealerId(current.getId());
            this.dealerCommunicationService.createBatch(dealerCommunication);
        }
        return current;
    }

    private DealerEntity createForm(DealerEntity dealer) {
        Date now = new Date();
        String account = this.getLoginAccountName();
        dealer.setTenantCode(TenantUtils.getTenantCode());
        dealer.setCreateAccount(account);
        dealer.setCreateTime(now);
        dealer.setModifyAccount(account);
        dealer.setModifyTime(now);
        this.createValidation(dealer);
        return dealer;
    }

    private String getLoginAccountName() {
        SecurityContext context = SecurityContextHolder.getContext();
        String account = "admin";
        if (context != null && context.getAuthentication() != null) {
            account = context.getAuthentication().getName();
        }
        return account;
    }

    private void createValidation(DealerEntity dealer) {
        Validate.notNull((Object)((Object)dealer), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)dealer.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        dealer.setId(null);
        Validate.notBlank((CharSequence)dealer.getTenantCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dealer.getCustomerCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u7ecf\u9500\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dealer.getCustomerName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u7ecf\u9500\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dealer.getChannelCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u6e20\u9053\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dealer.getCustomerType(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5ba2\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dealer.getOrgCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u6240\u5c5e\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dealer.getOrgName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u6240\u5c5e\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dealer.getLegalRepresent(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u8425\u4e1a\u6267\u7167\u6cd5\u4eba\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dealer.getCustomerContact(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5ba2\u6237\u8054\u7cfb\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dealer.getRegisteredAddress(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u6ce8\u518c\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dealer.getProvinceCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u7701\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dealer.getProvinceName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u7701\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dealer.getCityCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5e02\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dealer.getCityName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5e02\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dealer.getDistrictCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u533a\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dealer.getDistrictName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u533a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public void enable(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u542f\u7528\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.dealerRepository.updateEnableStatusByIds(EnableStatusEnum.ENABLE, ids);
    }

    @Override
    @Transactional
    public void disable(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u7981\u7528\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<DealerEntity> dealerEntities = this.dealerRepository.findByIds(ids);
        if (CollectionUtils.isNotEmpty(dealerEntities)) {
            ArrayList<String> customerCodes = new ArrayList<String>();
            for (DealerEntity entity : dealerEntities) {
                customerCodes.add(entity.getCustomerCode());
            }
            if (this.dealerEventListeners != null) {
                for (DealerEventListener eventListener : this.dealerEventListeners) {
                    eventListener.onDisable(customerCodes);
                }
            }
        }
        this.dealerRepository.updateEnableStatusByIds(EnableStatusEnum.DISABLE, ids);
    }

    @Override
    @Transactional
    public List<DealerEntity> createBatch(List<DealerEntity> dealers) {
        Validate.isTrue((!CollectionUtils.isEmpty(dealers) ? 1 : 0) != 0, (String)"\u8bf7\u4f20\u5165\u9700\u8981\u64cd\u4f5c\u7684\u6570\u636e", (Object[])new Object[0]);
        for (DealerEntity dealer : dealers) {
            this.createForm(dealer);
        }
        this.dealerRepository.saveBatch(dealers);
        return dealers;
    }
}

