/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.participator.local.service.internal;

import com.biz.crm.cps.business.consumer.sdk.service.ConsumerVoService;
import com.biz.crm.cps.business.consumer.sdk.vo.ConsumerVo;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.business.participator.sdk.service.DealerVoService;
import com.biz.crm.cps.business.participator.sdk.service.ParticipatorVoService;
import com.biz.crm.cps.business.participator.sdk.service.TerminalVoService;
import com.biz.crm.cps.business.participator.sdk.vo.ContactPersonVo;
import com.biz.crm.cps.business.participator.sdk.vo.DealerContactPersonVo;
import com.biz.crm.cps.business.participator.sdk.vo.DealerVo;
import com.biz.crm.cps.business.participator.sdk.vo.ParticipatorVo;
import com.biz.crm.cps.business.participator.sdk.vo.SupplyRelationshipVo;
import com.biz.crm.cps.business.participator.sdk.vo.TerminalVo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ParticipatorVoServiceImpl
implements ParticipatorVoService {
    @Autowired(required=false)
    private ConsumerVoService consumerVoService;
    @Autowired
    private TerminalVoService terminalVoService;
    @Autowired
    private DealerVoService dealerVoService;

    public List<ParticipatorVo> findByParticipatorTypeAndParticipatorCode(String participatorType, String participatorCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{participatorType, participatorCode})) {
            return Lists.newArrayList();
        }
        ArrayList<ParticipatorVo> participatorVos = new ArrayList<ParticipatorVo>();
        if (ParticipatorTypeEnum.CONSUMER.getDictCode().equals(participatorType)) {
            this.buildConsumerParticipator(participatorCode, participatorVos);
        }
        if (ParticipatorTypeEnum.TERMINAL.getDictCode().equals(participatorType)) {
            this.buildTerminalParticipator(participatorCode, participatorVos);
        }
        if (ParticipatorTypeEnum.DEALER.getDictCode().equals(participatorType)) {
            this.buildDealerParticipator(participatorCode, participatorVos);
        }
        return participatorVos;
    }

    private void buildConsumerParticipator(String participatorCode, List<ParticipatorVo> participatorVos) {
        if (StringUtils.isBlank((CharSequence)participatorCode)) {
            return;
        }
        ConsumerVo consumerVo = this.consumerVoService.findByExternalId(participatorCode);
        if (consumerVo == null) {
            return;
        }
        ParticipatorVo consumer = new ParticipatorVo();
        consumer.setParticipatorType(ParticipatorTypeEnum.CONSUMER.getDictCode());
        consumer.setParticipatorCode(consumerVo.getExternalId());
        consumer.setParticipatorName(consumerVo.getFullName());
        consumer.setPhone(consumerVo.getPhone());
        participatorVos.add(consumer);
        this.buildTerminalParticipator(consumerVo.getTerminalCode(), participatorVos);
    }

    private void buildTerminalParticipator(String participatorCode, List<ParticipatorVo> participatorVos) {
        if (StringUtils.isBlank((CharSequence)participatorCode)) {
            return;
        }
        List terminalCodes = this.terminalVoService.findByTerminalCodes(Arrays.asList(participatorCode));
        if (CollectionUtils.isEmpty((Collection)terminalCodes)) {
            return;
        }
        TerminalVo terminalCode = (TerminalVo)terminalCodes.get(0);
        ParticipatorVo terminal = new ParticipatorVo();
        terminal.setParticipatorType(ParticipatorTypeEnum.TERMINAL.getDictCode());
        terminal.setParticipatorCode(terminalCode.getTerminalCode());
        terminal.setParticipatorName(terminalCode.getTerminalName());
        terminal.setOrgCode(terminalCode.getOrganization());
        terminal.setChannel(terminalCode.getChannel());
        Set contactPersons = terminalCode.getContactPersons();
        if (CollectionUtils.isNotEmpty((Collection)contactPersons)) {
            terminal.setPhone(((ContactPersonVo)contactPersons.iterator().next()).getContactPersonPhone());
        }
        participatorVos.add(terminal);
        Set supplyRelationships = terminalCode.getSupplyRelationships();
        if (CollectionUtils.isNotEmpty((Collection)supplyRelationships)) {
            SupplyRelationshipVo supplyRelationshipVo = (SupplyRelationshipVo)supplyRelationships.iterator().next();
            this.buildDealerParticipator(supplyRelationshipVo.getExternalIdentifier(), participatorVos);
        }
    }

    private void buildDealerParticipator(String participatorCode, List<ParticipatorVo> participatorVos) {
        if (StringUtils.isBlank((CharSequence)participatorCode)) {
            return;
        }
        DealerVo dealerCode = this.dealerVoService.findDetailByCustomerCode(participatorCode);
        if (dealerCode == null) {
            return;
        }
        ParticipatorVo dealer = new ParticipatorVo();
        dealer.setParticipatorType(ParticipatorTypeEnum.DEALER.getDictCode());
        dealer.setParticipatorCode(dealerCode.getCustomerCode());
        dealer.setParticipatorName(dealerCode.getCustomerName());
        dealer.setOrgCode(dealerCode.getOrgCode());
        dealer.setOrgName(dealerCode.getOrgName());
        dealer.setChannel(dealerCode.getChannelCode());
        Set dealerContactPersons = dealerCode.getDealerContactPersons();
        if (CollectionUtils.isNotEmpty((Collection)dealerContactPersons)) {
            dealer.setPhone(((DealerContactPersonVo)dealerContactPersons.iterator().next()).getContactPersonPhone());
        }
        participatorVos.add(dealer);
    }
}

