/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.participator.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.cps.business.participator.local.entity.ContactPerson;
import com.biz.crm.cps.business.participator.local.entity.SupplyRelationship;
import com.biz.crm.cps.business.participator.local.entity.Terminal;
import com.biz.crm.cps.business.participator.local.repository.TerminalRepository;
import com.biz.crm.cps.business.participator.local.service.ContactPersonService;
import com.biz.crm.cps.business.participator.local.service.SupplyRelationshipService;
import com.biz.crm.cps.business.participator.local.service.TerminalService;
import com.biz.crm.cps.business.participator.local.service.state.TerminalStateHolder;
import com.biz.crm.cps.business.participator.sdk.common.enums.TerminalAuditStatusEnum;
import com.biz.crm.cps.business.participator.sdk.common.enums.TerminalTypeEnum;
import com.biz.crm.cps.business.participator.sdk.dto.TerminalPaginationDto;
import com.biz.crm.cps.business.participator.sdk.event.TerminalEventListener;
import com.biz.crm.cps.business.participator.sdk.vo.TerminalVo;
import com.biz.crm.cps.external.mdm.sdk.dto.TerminalMdmPaginationDto;
import com.biz.crm.cps.external.mdm.sdk.service.TerminalMdmService;
import com.biz.crm.cps.external.mdm.sdk.vo.TerminalMdmVo;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"TerminalServiceExpandImpl"})
public class TerminalServiceImpl
implements TerminalService {
    @Autowired
    TerminalRepository terminalRepository;
    @Autowired
    ContactPersonService contactPersonService;
    @Autowired
    SupplyRelationshipService supplyRelationshipService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private List<TerminalEventListener> terminalEventListenerList;
    @Autowired(required=false)
    private TerminalMdmService terminalMdmService;
    @Autowired
    TerminalStateHolder terminalStateHolder;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;

    @Override
    @Transactional
    public Terminal create(Terminal terminal) {
        Set<SupplyRelationship> supplyRelationships;
        List list = this.generateCodeService.generateCode("mdm_terminal", 1);
        terminal.setTerminalCode((String)list.get(0));
        terminal.setAuditStatus(TerminalAuditStatusEnum.UNDER_REVIEW.getDictCode());
        terminal.setTerminalType(TerminalTypeEnum.NEW_TERMINAL.getValue());
        Terminal current = this.createForm(terminal);
        this.terminalRepository.save((Object)current);
        Set<ContactPerson> contactPersons = terminal.getContactPersons();
        if (!CollectionUtils.isEmpty(contactPersons)) {
            contactPersons.stream().forEach(item -> item.setTerminalId(current.getId()));
            this.contactPersonService.createBatch(contactPersons);
        }
        if (!CollectionUtils.isEmpty(supplyRelationships = terminal.getSupplyRelationships())) {
            supplyRelationships.stream().forEach(item -> item.setTerminalId(current.getId()));
            this.supplyRelationshipService.createBatch(supplyRelationships);
        }
        return current;
    }

    @Override
    @Transactional
    public Terminal createForm(Terminal terminal) {
        Date now = new Date();
        String account = this.getLoginAccountName();
        terminal.setTenantCode(TenantUtils.getTenantCode());
        terminal.setCreateAccount(account);
        terminal.setCreateTime(now);
        terminal.setModifyAccount(account);
        terminal.setModifyTime(now);
        terminal.setSubmitTime(now);
        this.createValidation(terminal);
        return terminal;
    }

    @Override
    @Transactional
    public Terminal update(Terminal terminal) {
        Terminal current = this.updateForm(terminal);
        return current;
    }

    @Override
    @Transactional
    public Terminal updateForm(Terminal terminal) {
        this.updateValidation(terminal);
        String currentId = terminal.getId();
        Terminal currentTerminal = (Terminal)((Object)this.terminalRepository.getById((Serializable)((Object)currentId)));
        currentTerminal = (Terminal)((Object)Validate.notNull((Object)((Object)currentTerminal), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]));
        TerminalVo oldVo = null;
        if (!CollectionUtils.isEmpty(this.terminalEventListenerList)) {
            oldVo = (TerminalVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)currentTerminal, TerminalVo.class, HashSet.class, ArrayList.class, new String[0]);
        }
        Date now = new Date();
        String account = this.getLoginAccountName();
        currentTerminal.setModifyAccount(account);
        currentTerminal.setModifyTime(now);
        BeanUtils.copyProperties((Object)((Object)terminal), (Object)((Object)currentTerminal), (String[])new String[]{"id", "modifyTime", "createAccount", "createTime", "tenantCode", "openId"});
        this.terminalRepository.saveOrUpdate((Object)currentTerminal);
        if (!CollectionUtils.isEmpty(this.terminalEventListenerList)) {
            TerminalVo newVo = (TerminalVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)currentTerminal, TerminalVo.class, HashSet.class, ArrayList.class, new String[0]);
            for (TerminalEventListener event : this.terminalEventListenerList) {
                event.onChange(oldVo, newVo);
            }
        }
        return currentTerminal;
    }

    private String getLoginAccountName() {
        SecurityContext context = SecurityContextHolder.getContext();
        String account = "admin";
        if (context != null && context.getAuthentication() != null) {
            account = context.getAuthentication().getName();
        }
        return account;
    }

    @Override
    public Terminal findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (Terminal)((Object)this.terminalRepository.getById((Serializable)((Object)id)));
    }

    @Override
    public Terminal findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.terminalRepository.findDetailsById(id);
    }

    @Override
    public Terminal findDetailsByTerminalCode(String terminalCode) {
        if (StringUtils.isBlank((CharSequence)terminalCode)) {
            return null;
        }
        return this.terminalRepository.findDetailsByTerminalCode(terminalCode);
    }

    @Override
    public Page<Terminal> findByConditions(Pageable pageable, TerminalPaginationDto terminalPaginationDto) {
        terminalPaginationDto.setTenantCode(TenantUtils.getTenantCode());
        return this.terminalRepository.findByConditions(pageable, terminalPaginationDto);
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u8bf7\u9009\u4e2d\u8981\u64cd\u4f5c\u7684\u6570\u636e", (Object[])new Object[0]);
        this.terminalRepository.updateEnableStatusByIdIn(EnableStatusEnum.ENABLE, ids);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u8bf7\u4f20\u5165\u8981\u64cd\u4f5c\u7684\u6570\u636e", (Object[])new Object[0]);
        this.terminalRepository.updateEnableStatusByIdIn(EnableStatusEnum.DISABLE, ids);
        if (!CollectionUtils.isEmpty(this.terminalEventListenerList)) {
            List<Terminal> terminals = this.terminalRepository.findByIdIn(ids);
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(terminals, Terminal.class, TerminalVo.class, HashSet.class, ArrayList.class, new String[0]);
            for (TerminalEventListener event : this.terminalEventListenerList) {
                event.onDisable(voList);
            }
        }
    }

    @Override
    @Transactional
    public List<Terminal> createBatch(List<Terminal> terminalList) {
        Validate.isTrue((!CollectionUtils.isEmpty(terminalList) ? 1 : 0) != 0, (String)"\u8bf7\u4f20\u5165\u9700\u8981\u64cd\u4f5c\u7684\u6570\u636e", (Object[])new Object[0]);
        for (Terminal terminal : terminalList) {
            terminal.setAuditStatus(TerminalAuditStatusEnum.AUDIT_SUCCESS.getDictCode());
            terminal.setTerminalType(TerminalTypeEnum.DEALER_TERMINAL.getValue());
            this.createForm(terminal);
        }
        this.terminalRepository.saveBatch(terminalList);
        return terminalList;
    }

    @Override
    @Transactional
    public void pass(String id) {
        Terminal terminal = this.findById(id);
        Validate.notNull((Object)((Object)terminal), (String)"\u7ec8\u7aef\u4fe1\u606f\u5728\u672c\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        this.terminalStateHolder.pass(terminal);
    }

    @Override
    @Transactional
    public void cancel(String id) {
        Terminal terminal = this.findById(id);
        Validate.notNull((Object)((Object)terminal), (String)"\u7ec8\u7aef\u4fe1\u606f\u5728\u672c\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        this.terminalStateHolder.cancel(terminal);
    }

    @Override
    public Terminal findByOpenId(String openId) {
        if (StringUtils.isBlank((CharSequence)openId)) {
            return null;
        }
        return this.terminalRepository.findByOpenId(openId);
    }

    @Override
    public Terminal findByRegistrationNumber(String registrationNumber) {
        if (StringUtils.isBlank((CharSequence)registrationNumber)) {
            return null;
        }
        return this.terminalRepository.findByRegistrationNumber(registrationNumber);
    }

    @Override
    public Terminal findByTerminalCode(String terminalCode) {
        if (StringUtils.isBlank((CharSequence)terminalCode)) {
            return null;
        }
        return this.terminalRepository.findByTerminalCode(terminalCode);
    }

    @Override
    public Page<Terminal> findByDealerId(String dealerId, Pageable pageable) {
        if (StringUtils.isBlank((CharSequence)dealerId)) {
            return new Page();
        }
        return this.terminalRepository.findByDealerId(pageable, dealerId);
    }

    @Override
    @Transactional
    public void create(TerminalMdmPaginationDto terminalMdmPaginationDto) {
        List terminalMdmVos = this.terminalMdmService.findByConditions(terminalMdmPaginationDto);
        Validate.notEmpty((Collection)terminalMdmVos, (String)"\u6ca1\u6709\u53d1\u73b0\u9700\u8981\u51c6\u5165\u7684\u7ec8\u7aef\u4fe1\u606f", (Object[])new Object[0]);
        List terminals = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)terminalMdmVos, TerminalMdmVo.class, Terminal.class, HashSet.class, ArrayList.class, new String[]{"contactPersons", "supplyRelationships"});
        this.createBatch(terminals);
    }

    private void createValidation(Terminal terminal) {
        Validate.notNull((Object)((Object)terminal), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)terminal.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        terminal.setId(null);
        Validate.notBlank((CharSequence)terminal.getTenantCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminal.getTerminalCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5206\u5229\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminal.getTerminalName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5206\u5229\u7ec8\u7aef\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminal.getChannel(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminal.getLegalPersonSName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u8425\u4e1a\u6267\u7167\u6cd5\u4eba\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminal.getRegistrationNumber(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u8425\u4e1a\u6267\u7167\u6ce8\u518c\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminal.getCompanyName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u8425\u4e1a\u6267\u7167\u4f01\u4e1a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((terminal.getTerminalCode() == null || terminal.getTerminalCode().length() < 64 ? 1 : 0) != 0, (String)"\u5206\u5229\u7ec8\u7aef\u7f16\u7801,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getTerminalName() == null || terminal.getTerminalName().length() < 128 ? 1 : 0) != 0, (String)"\u5206\u5229\u7ec8\u7aef\u540d\u79f0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getTerminalType() == null || terminal.getTerminalType().length() < 128 ? 1 : 0) != 0, (String)"\u5206\u5229\u7ec8\u7aef\u7c7b\u578b,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getOrganization() == null || terminal.getOrganization().length() < 128 ? 1 : 0) != 0, (String)"\u6240\u5c5e\u7ec4\u7ec7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getCustomerOrganization() == null || terminal.getCustomerOrganization().length() < 128 ? 1 : 0) != 0, (String)"\u5ba2\u6237\u7ec4\u7ec7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getChannel() == null || terminal.getChannel().length() < 128 ? 1 : 0) != 0, (String)"\u6e20\u9053,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getLegalPersonSName() == null || terminal.getLegalPersonSName().length() < 128 ? 1 : 0) != 0, (String)"\u8425\u4e1a\u6267\u7167\u6cd5\u4eba\u59d3\u540d,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getRegistrationNumber() == null || terminal.getRegistrationNumber().length() < 128 ? 1 : 0) != 0, (String)"\u8425\u4e1a\u6267\u7167\u6ce8\u518c\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getCompanyName() == null || terminal.getCompanyName().length() < 128 ? 1 : 0) != 0, (String)"\u8425\u4e1a\u6267\u7167\u4f01\u4e1a\u540d\u79f0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getProvinceCode() == null || terminal.getProvinceCode().length() < 32 ? 1 : 0) != 0, (String)"\u7701\u7f16\u7801,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getProvinceName() == null || terminal.getProvinceName().length() < 32 ? 1 : 0) != 0, (String)"\u7701\u540d\u79f0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getCityCode() == null || terminal.getCityCode().length() < 32 ? 1 : 0) != 0, (String)"\u5e02\u7f16\u7801,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getCityName() == null || terminal.getCityName().length() < 32 ? 1 : 0) != 0, (String)"\u5e02\u540d\u79f0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getDistrictCode() == null || terminal.getDistrictCode().length() < 32 ? 1 : 0) != 0, (String)"\u533a\u7f16\u7801,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getDistrictName() == null || terminal.getDistrictName().length() < 32 ? 1 : 0) != 0, (String)"\u533a\u540d\u79f0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getTerminalAddress() == null || terminal.getTerminalAddress().length() < 128 ? 1 : 0) != 0, (String)"\u7ec8\u7aef\u5730\u5740,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getShopSignPath() == null || terminal.getShopSignPath().length() < 64 ? 1 : 0) != 0, (String)"\u5e97\u62db\u7167\u7247\u6587\u4ef6\u5939,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getShopSignFilename() == null || terminal.getShopSignFilename().length() < 64 ? 1 : 0) != 0, (String)"\u5e97\u62db\u7167\u7247\u6587\u4ef6\u540d,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getBusinessLicensePath() == null || terminal.getBusinessLicensePath().length() < 64 ? 1 : 0) != 0, (String)"\u8425\u4e1a\u6267\u7167\u7167\u7247\u6587\u4ef6\u5939,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getBusinessLicenseFilename() == null || terminal.getBusinessLicenseFilename().length() < 64 ? 1 : 0) != 0, (String)"\u8425\u4e1a\u6267\u7167\u7167\u7247\u6587\u4ef6\u540d,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getOpenId() == null || terminal.getOpenId().length() < 64 ? 1 : 0) != 0, (String)"openId,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    private void updateValidation(Terminal terminal) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)terminal.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminal.getTenantCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminal.getTerminalCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5206\u5229\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminal.getTerminalName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5206\u5229\u7ec8\u7aef\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminal.getChannel(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminal.getLegalPersonSName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u8425\u4e1a\u6267\u7167\u6cd5\u4eba\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminal.getRegistrationNumber(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u8425\u4e1a\u6267\u7167\u6ce8\u518c\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminal.getCompanyName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u8425\u4e1a\u6267\u7167\u4f01\u4e1a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((terminal.getTerminalCode() == null || terminal.getTerminalCode().length() < 64 ? 1 : 0) != 0, (String)"\u5206\u5229\u7ec8\u7aef\u7f16\u7801,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getTerminalName() == null || terminal.getTerminalName().length() < 128 ? 1 : 0) != 0, (String)"\u5206\u5229\u7ec8\u7aef\u540d\u79f0,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getTerminalType() == null || terminal.getTerminalType().length() < 128 ? 1 : 0) != 0, (String)"\u5206\u5229\u7ec8\u7aef\u7c7b\u578b,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getOrganization() == null || terminal.getOrganization().length() < 128 ? 1 : 0) != 0, (String)"\u6240\u5c5e\u7ec4\u7ec7,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getCustomerOrganization() == null || terminal.getCustomerOrganization().length() < 128 ? 1 : 0) != 0, (String)"\u5ba2\u6237\u7ec4\u7ec7,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getChannel() == null || terminal.getChannel().length() < 128 ? 1 : 0) != 0, (String)"\u6e20\u9053,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getLegalPersonSName() == null || terminal.getLegalPersonSName().length() < 128 ? 1 : 0) != 0, (String)"\u8425\u4e1a\u6267\u7167\u6cd5\u4eba\u59d3\u540d,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getRegistrationNumber() == null || terminal.getRegistrationNumber().length() < 128 ? 1 : 0) != 0, (String)"\u8425\u4e1a\u6267\u7167\u6ce8\u518c\u53f7,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getCompanyName() == null || terminal.getCompanyName().length() < 128 ? 1 : 0) != 0, (String)"\u8425\u4e1a\u6267\u7167\u4f01\u4e1a\u540d\u79f0,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getProvinceCode() == null || terminal.getProvinceCode().length() < 32 ? 1 : 0) != 0, (String)"\u7701\u7f16\u7801,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getProvinceName() == null || terminal.getProvinceName().length() < 32 ? 1 : 0) != 0, (String)"\u7701\u540d\u79f0,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getCityCode() == null || terminal.getCityCode().length() < 32 ? 1 : 0) != 0, (String)"\u5e02\u7f16\u7801,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getCityName() == null || terminal.getCityName().length() < 32 ? 1 : 0) != 0, (String)"\u5e02\u540d\u79f0,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getDistrictCode() == null || terminal.getDistrictCode().length() < 32 ? 1 : 0) != 0, (String)"\u533a\u7f16\u7801,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getDistrictName() == null || terminal.getDistrictName().length() < 32 ? 1 : 0) != 0, (String)"\u533a\u540d\u79f0,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getTerminalAddress() == null || terminal.getTerminalAddress().length() < 128 ? 1 : 0) != 0, (String)"\u7ec8\u7aef\u5730\u5740,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getShopSignPath() == null || terminal.getShopSignPath().length() < 64 ? 1 : 0) != 0, (String)"\u5e97\u62db\u7167\u7247\u6587\u4ef6\u5939,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getShopSignFilename() == null || terminal.getShopSignFilename().length() < 64 ? 1 : 0) != 0, (String)"\u5e97\u62db\u7167\u7247\u6587\u4ef6\u540d,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getBusinessLicensePath() == null || terminal.getBusinessLicensePath().length() < 64 ? 1 : 0) != 0, (String)"\u8425\u4e1a\u6267\u7167\u7167\u7247\u6587\u4ef6\u5939,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getBusinessLicenseFilename() == null || terminal.getBusinessLicenseFilename().length() < 64 ? 1 : 0) != 0, (String)"\u8425\u4e1a\u6267\u7167\u7167\u7247\u6587\u4ef6\u540d,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getOpenId() == null || terminal.getOpenId().length() < 64 ? 1 : 0) != 0, (String)"openId,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }
}

