/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.participator.local.service.internal;

import com.biz.crm.cps.business.participator.local.entity.Terminal;
import com.biz.crm.cps.business.participator.local.repository.TerminalRepository;
import com.biz.crm.cps.business.participator.sdk.service.TerminalVoService;
import com.biz.crm.cps.business.participator.sdk.vo.TerminalVo;
import com.biz.crm.cps.external.mdm.sdk.dto.TerminalMdmPaginationDto;
import com.biz.crm.cps.external.mdm.sdk.service.TerminalMdmService;
import com.biz.crm.cps.external.mdm.sdk.vo.TerminalMdmVo;
import com.bizunited.platform.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TerminalVoServiceImpl
implements TerminalVoService {
    @Autowired
    private TerminalRepository terminalRepository;
    @Autowired(required=false)
    private TerminalMdmService terminalMdmService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    public List<TerminalVo> findByTerminalCodes(List<String> terminalCodes) {
        if (CollectionUtils.isEmpty(terminalCodes)) {
            return null;
        }
        List<Terminal> terminals = this.terminalRepository.findByTerminalCodes(terminalCodes);
        if (CollectionUtils.isEmpty(terminals)) {
            return null;
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(terminals, Terminal.class, TerminalVo.class, HashSet.class, ArrayList.class, new String[]{"contactPersons", "supplyRelationships"});
    }

    public TerminalVo validate(TerminalVo terminal) {
        Validate.notNull((Object)terminal, (String)"\u7ec8\u7aef\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminal.getRegistrationNumber(), (String)"\u8425\u4e1a\u6267\u7167\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminal.getTerminalName(), (String)"\u7ec8\u7aef\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminal.getTerminalAddress(), (String)"\u7ec8\u7aef\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        TerminalMdmPaginationDto terminalMdmPaginationDto = new TerminalMdmPaginationDto();
        terminalMdmPaginationDto.setLicenseRegisterNumber(terminal.getRegistrationNumber());
        terminalMdmPaginationDto.setTerminalName(terminal.getTerminalName());
        terminalMdmPaginationDto.setTerminalAddress(terminal.getTerminalAddress());
        TerminalMdmVo terminalMdmVo = this.terminalMdmService.findDetailByRegisterOrName(terminalMdmPaginationDto);
        TerminalVo resultTerminal = new TerminalVo();
        if (terminalMdmVo == null) {
            resultTerminal.setResultType(Integer.valueOf(1));
            return resultTerminal;
        }
        Terminal cpsTerminal = this.terminalRepository.validate(terminal);
        if (cpsTerminal == null) {
            resultTerminal = (TerminalVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)terminalMdmVo, TerminalVo.class, HashSet.class, ArrayList.class, new String[0]);
            resultTerminal.setResultType(Integer.valueOf(2));
        } else {
            resultTerminal.setResultType(Integer.valueOf(3));
        }
        return resultTerminal;
    }
}

