/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.participator.local.service.internal;

import com.biz.crm.cps.business.participator.local.entity.ContactPerson;
import com.biz.crm.cps.business.participator.local.repository.ContactPersonRepository;
import com.biz.crm.cps.business.participator.local.service.ContactPersonService;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ContactPersonServiceImpl
implements ContactPersonService {
    @Autowired
    ContactPersonRepository contactPersonRepository;

    @Override
    @Transactional
    public ContactPerson createForm(ContactPerson contactPerson) {
        this.createValidation(contactPerson);
        return contactPerson;
    }

    @Override
    @Transactional
    public void createBatch(Collection<ContactPerson> contactPersons) {
        if (CollectionUtils.isEmpty(contactPersons)) {
            return;
        }
        for (ContactPerson contactPerson : contactPersons) {
            this.createForm(contactPerson);
        }
        this.contactPersonRepository.saveBatch(contactPersons);
    }

    @Override
    public List<ContactPerson> findByTerminalId(String terminalId) {
        if (StringUtils.isBlank((CharSequence)terminalId)) {
            return null;
        }
        return this.contactPersonRepository.findByTerminalId(terminalId);
    }

    @Override
    @Transactional
    public void updateBatch(Set<ContactPerson> contactPersons) {
        if (CollectionUtils.isEmpty(contactPersons)) {
            return;
        }
        for (ContactPerson contactPerson : contactPersons) {
            this.updateValidation(contactPerson);
        }
        this.contactPersonRepository.saveOrUpdateBatch(contactPersons);
    }

    private void updateValidation(ContactPerson contactPerson) {
        Validate.notNull((Object)((Object)contactPerson), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)contactPerson.getTerminalId(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u8054\u7cfb\u4eba\u7684\u7ec8\u7aef\u4fe1\u606f\u4e0d\u80fd\u6ca1\u6709\u4e3b\u952e\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)contactPerson.getContactPersonName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u8054\u7cfb\u4eba\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((contactPerson.getContactPersonName() == null || contactPerson.getContactPersonName().length() < 128 ? 1 : 0) != 0, (String)"\u8054\u7cfb\u4eba\u59d3\u540d,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((contactPerson.getContactPersonPhone() == null || contactPerson.getContactPersonPhone().length() < 64 ? 1 : 0) != 0, (String)"\u8054\u7cfb\u4eba\u7535\u8bdd,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((contactPerson.getTerminalId() == null || contactPerson.getTerminalId().length() < 255 ? 1 : 0) != 0, (String)"\u5206\u5229\u7ec8\u7aefID,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    private void createValidation(ContactPerson contactPerson) {
        Validate.notNull((Object)((Object)contactPerson), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)contactPerson.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        contactPerson.setId(null);
        Validate.notBlank((CharSequence)contactPerson.getTerminalId(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u8054\u7cfb\u4eba\u7684\u7ec8\u7aef\u4fe1\u606f\u4e0d\u80fd\u6ca1\u6709\u4e3b\u952e\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)contactPerson.getContactPersonName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u8054\u7cfb\u4eba\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((contactPerson.getContactPersonName() == null || contactPerson.getContactPersonName().length() < 128 ? 1 : 0) != 0, (String)"\u8054\u7cfb\u4eba\u59d3\u540d,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((contactPerson.getContactPersonPhone() == null || contactPerson.getContactPersonPhone().length() < 64 ? 1 : 0) != 0, (String)"\u8054\u7cfb\u4eba\u7535\u8bdd,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((contactPerson.getTerminalId() == null || contactPerson.getTerminalId().length() < 255 ? 1 : 0) != 0, (String)"\u5206\u5229\u7ec8\u7aefID,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }
}

