/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.participator.local.service.internal;

import com.biz.crm.cps.business.participator.local.entity.ParticipatorTag;
import com.biz.crm.cps.business.participator.local.repository.ParticipatorTagRepository;
import com.biz.crm.cps.business.participator.local.service.ParticipatorTagService;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ParticipatorTagServiceImpl
implements ParticipatorTagService {
    @Autowired
    private ParticipatorTagRepository participatorTagRepository;

    @Override
    @Transactional
    public void createBatch(Set<ParticipatorTag> participatorTags) {
        if (CollectionUtils.isEmpty(participatorTags)) {
            return;
        }
        for (ParticipatorTag participatorTag : participatorTags) {
            this.createForm(participatorTag);
        }
        this.participatorTagRepository.saveBatch(participatorTags);
    }

    @Override
    @Transactional
    public ParticipatorTag createForm(ParticipatorTag participatorTag) {
        this.createValidation(participatorTag);
        return participatorTag;
    }

    @Override
    public List<ParticipatorTag> findTerminalTagByTagDescriptionLike(String tagDescription) {
        if (StringUtils.isBlank((CharSequence)tagDescription)) {
            return null;
        }
        return this.participatorTagRepository.findTerminalTagByTagDescriptionLike(tagDescription);
    }

    @Override
    public List<ParticipatorTag> findDealerTagByTagDescriptionLike(String tagDescription) {
        if (StringUtils.isBlank((CharSequence)tagDescription)) {
            return null;
        }
        return this.participatorTagRepository.findDealerTagByTagDescriptionLike(tagDescription);
    }

    private void createValidation(ParticipatorTag participatorTag) {
        Validate.notNull((Object)((Object)participatorTag), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)participatorTag.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        participatorTag.setId(null);
        Validate.notBlank((CharSequence)participatorTag.getParticipatorCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u53c2\u4e0e\u8005\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)participatorTag.getTagType(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u6807\u7b7e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)participatorTag.getTagDescription(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u6807\u7b7e\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((participatorTag.getParticipatorCode() == null || participatorTag.getParticipatorCode().length() < 64 ? 1 : 0) != 0, (String)"\u5206\u5229\u53c2\u4e0e\u8005\u7f16\u7801,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((participatorTag.getTagType() == null || participatorTag.getTagType().length() < 64 ? 1 : 0) != 0, (String)"\u6807\u7b7e\u7c7b\u578b,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((participatorTag.getTagDescription() == null || participatorTag.getTagDescription().length() < 64 ? 1 : 0) != 0, (String)"\u6807\u7b7e\u63cf\u8ff0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }
}

