/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.participator.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.participator.local.entity.DealerEntity;
import com.biz.crm.cps.business.participator.local.mapper.DealerMapper;
import com.biz.crm.cps.business.participator.sdk.dto.DealerDto;
import com.biz.crm.cps.business.participator.sdk.vo.DealerVo;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class DealerRepository
extends ServiceImpl<DealerMapper, DealerEntity> {
    @Resource
    private DealerMapper dealerMapper;

    public Page<DealerVo> findByConditions(Pageable pageable, DealerDto dealerDto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.dealerMapper.findByConditions((Page<DealerVo>)page, dealerDto);
    }

    public void updateEnableStatusByIds(EnableStatusEnum enable, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"enable_status", (Object)enable.getCode());
        updateWrapper.in((Object)"id", ids);
        this.update((Wrapper)updateWrapper);
    }

    public List<DealerEntity> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return null;
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"id", ids);
        return this.list((Wrapper)wrapper);
    }

    public DealerEntity findByCustomerCode(String customerCode) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"customer_code", (Object)customerCode);
        return (DealerEntity)((Object)this.getOne((Wrapper)wrapper));
    }

    public List<String> findCustomerCodeByCustomerCodes(Set<String> customerCodes) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.select(new String[]{"customer_code"});
        wrapper.in((Object)"customer_code", customerCodes);
        return this.listObjs((Wrapper)wrapper, Object::toString);
    }

    public List<DealerEntity> findByType(String type) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"customer_type", new Object[]{type});
        return this.list((Wrapper)wrapper);
    }

    public DealerEntity findByCustomerCodeAndEnable(String customerCode, String enableStatus) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"customer_code", (Object)customerCode);
        wrapper.eq((Object)"enable_status", (Object)enableStatus);
        return (DealerEntity)((Object)this.getOne((Wrapper)wrapper));
    }
}

