/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.participator.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.participator.sdk.dto.DealerDto;
import com.biz.crm.cps.business.participator.sdk.service.DealerVoService;
import com.biz.crm.cps.business.participator.sdk.vo.DealerVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5206\u5229\u7ecf\u9500\u5546"})
@RestController
@RequestMapping(value={"/v1/participator/dealer"})
public class DealerVoController {
    private static final Logger log = LoggerFactory.getLogger(DealerVoController.class);
    @Autowired
    private DealerVoService dealerVoService;

    @ApiOperation(value="\u6761\u4ef6\u67e5\u8be2\u5206\u5229\u7ecf\u9500\u5546\u5217\u8868")
    @GetMapping(value={"findByConditions"})
    public Result<Page<DealerVo>> findByConditions(@ApiParam(name="dealerDto", value="\u7ecf\u9500\u5546\u5217\u8868vo") DealerDto dealerDto, @PageableDefault(value=50) Pageable pageable) {
        try {
            Page vos = this.dealerVoService.findByConditions(dealerDto, pageable);
            return Result.ok((Object)vos);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u8be6\u60c5(\u5305\u62ec\u5173\u8054\u4fe1\u606f)")
    @GetMapping(value={"findDetailById"})
    public Result<DealerVo> findDetailById(@RequestParam(value="id") @ApiParam(name="id", value="\u4e3b\u952e") String id) {
        try {
            DealerVo vo = this.dealerVoService.findDetailById(id);
            return Result.ok((Object)vo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u7ecf\u9500\u5546\u7f16\u7801\u67e5\u8be2")
    @GetMapping(value={"findByCustomerCode"})
    public Result<DealerVo> findByCustomerCode(@RequestParam(value="customerCode") @ApiParam(name="customerCode", value="\u7ecf\u9500\u5546\u7f16\u7801") String customerCode) {
        try {
            DealerVo vo = this.dealerVoService.findByCustomerCode(customerCode);
            return Result.ok((Object)vo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u7f16\u7801\u67e5\u8be2\u8be6\u60c5(\u5305\u62ec\u5173\u8054\u4fe1\u606f)")
    @GetMapping(value={"findDetailByCustomerCode"})
    public Result<DealerVo> findDetailByCustomerCode(@RequestParam(value="customerCode") @ApiParam(name="customerCode", value="\u7f16\u7801") String customerCode) {
        try {
            DealerVo vo = this.dealerVoService.findDetailByCustomerCode(customerCode);
            return Result.ok((Object)vo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

