package com.biz.crm.cps.business.participator.sdk.common.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * @author songjingen
 * @Description: 参与者类型
 **/
public enum ParticipatorTypeEnum {
  /**
   * 编码与描述
   */
  DEALER("c", "1","经销商", "1"),
  TERMINAL("terminal", "2","终端", "2"),
  CONSUMER("consumer", "3", "消费者", "3"),
  USER_GUIDE("user_guide", "4", "导购", "4");

  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  ParticipatorTypeEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  public String getDictCode() {
    return dictCode;
  }

  /**
   * 通过key获取 ParticipatorTypeEnum
   *
   * @param key
   * @return
   */
  public static ParticipatorTypeEnum getByKey(String key) {
    return Arrays.stream(ParticipatorTypeEnum.values()).filter(item -> Objects.equals(item.getKey(), key))
        .findFirst().orElse(null);
  }

  public static ParticipatorTypeEnum getByDictCode(String dictCode) {
    return Arrays.stream(ParticipatorTypeEnum.values()).filter(item -> Objects.equals(item.getDictCode(), dictCode))
            .findFirst().orElse(null);
  }

  /**
   * 通过flag获取 ParticipatorTypeEnum
   *
   * @param value
   * @return
   */
  public static ParticipatorTypeEnum getByValue(String value) {
    return Arrays.stream(ParticipatorTypeEnum.values()).filter(item -> Objects.equals(item.getValue(), value))
        .findFirst().orElse(null);
  }
}

