package com.biz.crm.cps.business.participator.sdk.common.enums;

/**
 * 终端审核状态枚举
 *
 * @author hefan
 */
public enum TerminalAuditStatusEnum {
  /**
   * 审核中
   */
  UNDER_REVIEW("underReview", "underReview", "审核中", ""),

  /**
   * 审核通过
   */
  AUDIT_SUCCESS("auditSuccess", "auditSuccess", "审核通过", ""),

  /**
   * 审核驳回
   */
  AUDIT_REJECT("auditReject", "auditReject", "审核驳回", "");

  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  TerminalAuditStatusEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }
}
