package com.biz.crm.cps.business.participator.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 分利经销商列表dto
 * @Author: zengxingwang
 * @Date: 2021/7/19 15:56
 */
@Data
@ApiModel(description = "分利经销商列表dto")
public class DealerDto {

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String customerCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  private String customerName;

  /**
   * 累计金额大于等于
   */
  @ApiModelProperty("累计金额大于等于")
  private BigDecimal greaterAccruingAmount;

  /**
   * 累计金额小于
   */
  @ApiModelProperty("累计金额小于")
  private BigDecimal lessAccruingAmount;

  /**
   * 累计积分大于等于
   */
  @ApiModelProperty("累计积分大于等于")
  private BigDecimal greaterAccruingIntegral;

  /**
   * 累计积分小于
   */
  @ApiModelProperty("累计积分小于")
  private BigDecimal lessAccruingIntegral;

  /**
   * 准入时间-开始
   */
  @ApiModelProperty("准入时间-开始")
  private String accessTimeStart;

  /**
   * 准入时间-结束
   */
  @ApiModelProperty("准入时间-结束")
  private String accessTimeEnd;

  /**
   * 所属组织
   */
  @ApiModelProperty("所属组织")
  private String orgCode;

  /**
   * 渠道类型
   */
  @ApiModelProperty("渠道类型")
  private String channelCode;

  /**
   * 分利状态
   */
  @ApiModelProperty("分利状态")
  private Integer dividendStatus;

  /**
   * 虚拟账户状态
   */
  @ApiModelProperty("虚拟账户状态")
  private Integer accountStatus;

  /**
   * 客户组织编码
   */
  @ApiModelProperty("客户组织编码")
  private String customerOrgCode;

  /**
   * 标签信息
   */
  @ApiModelProperty("标签信息")
  private String tagDescription;

  /**
   * 所属组织列表
   */
  @ApiModelProperty("所属组织列表")
  private List<String> orgCodes;

  /**
   * 渠道类型列表
   */
  @ApiModelProperty("渠道类型列表")
  private List<String> channelCodes;

  /**
   * 标签信息列表
   */
  @ApiModelProperty("标签信息列表")
  private List<String> tagDescriptions;

}
