package com.biz.crm.cps.business.participator.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * SupplyRelationshipDto
 *
 * @Author: hefan
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SupplyRelationshipDto", description = "供货关系Dto")
public class SupplyRelationshipDto {

  /**
   * 分利终端ID
   */
  @ApiModelProperty("分利终端ID")
  private String terminalId;

  /**
   * 业务员
   */
  @ApiModelProperty("业务员")
  private String salesman;

  /**
   * 业务员组织
   */
  @ApiModelProperty("业务员组织")
  private String salesmanOrganization;

  /**
   * 上级客户
   */
  @ApiModelProperty("上级客户")
  private String superiorCustomer;

  /**
   * 外部（经销商）唯一标识
   */
  @ApiModelProperty("外部（经销商）唯一标识")
  private String externalIdentifier;
}
