package com.biz.crm.cps.business.participator.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 终端查询Dto
 * @Author dy
 * @DATE 2022/4/8
 **/
@Data
@ApiModel("分利终端终端查询Dto")
public class TerminalConditionDto implements Serializable {

  private static final long serialVersionUID = 2760347315642434426L;

  /**
   * 租户编号 不用向外暴露
   */
  private String tenantCode;

  /**
   * 分利终端编码
   */
  @ApiModelProperty("分利终端编码")
  private String terminalCode;

  /**
   * 分利终端名称
   */
  @ApiModelProperty("分利终端名称")
  private String terminalName;

  /**
   * 所属组织
   */
  @ApiModelProperty("所属组织")
  private String organizationName;

  /**
   * 客户组织
   */
  @ApiModelProperty("客户组织")
  private String customerOrganizationName;

  /**
   * 渠道
   */
  @ApiModelProperty("渠道")
  private String channel;

  /**
   * 分利终端类型
   */
  @ApiModelProperty("分利终端类型")
  private String terminalType;

  /**
   * 分利终端标签
   */
  @ApiModelProperty("终端标签")
  private String tagDescription;

  /**
   * 分利终端标签列表
   */
  @ApiModelProperty("分利终端标签列表")
  private List<String> tagDescriptions;

  /**
   * 准入开始时间
   */
  @ApiModelProperty(name = "createTimeStart", value = "准入开始时间")
  private String createTimeStart;

  /**
   * 准入结束时间
   */
  @ApiModelProperty(name = "createTimeEnd", value = "准入结束时间")
  private String createTimeEnd;
}
