package com.biz.crm.cps.business.participator.sdk.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * TerminalPaginationDto 终端分页查询dto
 *
 * @Author: hefan
 * @Date: 2021/7/22 10:44
 */
@Data
@ApiModel
public class TerminalPaginationDto implements Serializable {

  /**
   * 
   */
  private static final long serialVersionUID = 1393731765635029271L;

  /**
   * 分利终端编码
   */
  @ApiModelProperty("分利终端编码")
  private String terminalCode;

  /**
   * 分利终端名称
   */
  @ApiModelProperty("分利终端名称")
  private String terminalName;

  /**
   * 所属组织
   */
  @ApiModelProperty("所属组织")
  private String organization;

  /**
   * 客户组织
   */
  @ApiModelProperty("客户组织")
  private String customerOrganization;

  /**
   * 渠道
   */
  @ApiModelProperty("渠道")
  private String channel;

  /**
   * 分利终端类型
   */
  @ApiModelProperty("分利终端类型")
  private String terminalType;

  /**
   * 分利终端来源
   */
  @ApiModelProperty("分利终端来源")
  private String terminalSource;

  /**
   * 租户编号 不用向外暴露
   */
  private String tenantCode;

  /**
   * 分利状态
   */
  @ApiModelProperty("分利状态")
  private String enableStatus;

  /**
   * 审核状态
   */
  @ApiModelProperty("审核状态")
  private String auditStatus;

  /**
   * 准入开始时间
   */
  @ApiModelProperty(name = "createTimeStart", value = "准入开始时间")
  private String createTimeStart;

  /**
   * 准入结束时间
   */
  @ApiModelProperty(name = "createTimeEnd", value = "准入结束时间")
  private String createTimeEnd;

  /**
   * 上级客户
   */
  @ApiModelProperty("上级客户")
  private String superiorCustomer;

  /**
   * 上级客户编码
   */
  @ApiModelProperty("上级客户编码")
  private String customerCode;


}
