package com.biz.crm.cps.business.participator.sdk.event;

import com.biz.crm.cps.business.participator.sdk.vo.TerminalVo;

import java.util.List;

/**
 * TerminalEventListener
 * 终端基础数据操作事件通知
 *
 * @Author: hefan
 * @Date: 2021/7/21 10:07
 */
public interface TerminalEventListener {

  /**
   * 当禁用时，触发事件
   * @param terminalVo
   * @return
   */
  String onDisable(List<TerminalVo> terminalVo);

  /**
   * 当修改时，触发事件
   * @param oldVo
   * @param newVo
   * @return
   */
  String onChange(TerminalVo oldVo, TerminalVo newVo);
}
