package com.biz.crm.cps.business.participator.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.participator.sdk.dto.DealerConditionDto;
import com.biz.crm.cps.business.participator.sdk.dto.DealerDto;
import com.biz.crm.cps.business.participator.sdk.vo.DealerVo;
import org.springframework.data.domain.Pageable;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * 经销商接口定义
 * @Author: zengxingwang
 * @Date: 2021/7/19 16:03
 */
public interface DealerVoService {

  /**
   * 条件查询分利经销商列表
   * @param dealerDto
   * @return
   */
  Page<DealerVo> findByConditions(DealerDto dealerDto, Pageable pageable);

  /**
   * 根据id查询详情(包括关联信息)
   * @param id
   * @return
   */
  DealerVo findDetailById(String id);

  /**
   * 根据经销商编码查询
   * @param customerCode
   * @return
   */
  DealerVo findByCustomerCode(String customerCode);

  /**
   * 根据经销商编码查询（包括关联信息）
   * @param customerCode
   * @return
   */
  DealerVo findDetailByCustomerCode(String customerCode);

  /**
   * 根据经销商编码查询
   * @param customerCodes
   * @return
   */
  List<DealerVo> findByCustomerCodes(List<String> customerCodes);

  /**
   * 条件查询经销商列表
   * @param dealerDto 查询条件
   * @return 经销商列表
   */
  Set<DealerVo> findByConditions(DealerDto dealerDto);

  /**
   * 条件查询客户编码集合
   * @param dealerConditionDto
   * @return
   */
  Set<String> findCustomerCodeByConditions(DealerConditionDto dealerConditionDto);

  /**
   * 根据组织集合、渠道集合、标签集合查询客户编码集合
   *
   * @param orgCodes 组织集合
   * @param channels 渠道集合
   * @param tags 标签集合
   * @return 客户编码集合
   */
  default Set<String> findCustomerCodesByOrgCodesAndChannelsAndTags(List<String> orgCodes, List<String> channels, List<String> tags){
    return new HashSet<>();
  }
}
