package com.biz.crm.cps.business.participator.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.participator.sdk.dto.TerminalConditionDto;
import com.biz.crm.cps.business.participator.sdk.dto.TerminalDto;
import com.biz.crm.cps.business.participator.sdk.dto.TerminalPaginationDto;
import com.biz.crm.cps.business.participator.sdk.vo.TerminalVo;
import com.google.common.collect.Sets;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Set;

/** TerminalVoService @Author: hefan */
public interface TerminalVoService {

  /**
   * 根据终端编码集合查询
   *
   * @param terminalCodes
   * @return
   */
  List<TerminalVo> findByTerminalCodes(List<String> terminalCodes);

  /**
   * 验证终端
   *
   * @param terminal
   * @return
   */
  TerminalVo validate(TerminalVo terminal);

  /**
   * 根据经销商外部标识获取关联终端编码集合
   *
   * @param dealerCode
   * @return
   */
  List<String> findByExternalIdentifier(String dealerCode);

  /**
   * 条件查询终端列表
   *
   * @param terminalDto 查询条件
   * @return 终端列表
   */
  Set<TerminalVo> findByConditions(TerminalDto terminalDto);

  /**
   * 条件查询终端编码
   * @param terminalDto
   * @return
   */
  Set<String> findTerminalCodeByConditions(TerminalConditionDto terminalConditionDto);

  /**
   * 条件查询终端列表
   *
   * @param terminalPaginationDto 查询条件
   * @return 终端列表
   */
  Page<TerminalVo> findByConditions(Pageable pageable, TerminalPaginationDto terminalPaginationDto);

  /**
   * 根据组织、渠道、标签获取匹配的终端编码
   *
   * @param orgCodes
   * @param channels
   * @param tags
   * @return
   */
  default Set<String> findTerminalCodesByOrgCodesAndChannelsAndTags(
      Set<String> orgCodes, Set<String> channels, Set<String> tags) {
    return Sets.newHashSet();
  }

  /**
   * 经销商供货关系终端分页数据
   * 
   * @param pageable
   * @param terminalPaginationDto
   * @return
   */
  default Page<TerminalVo> findBySupplyConditions(Pageable pageable, TerminalPaginationDto terminalPaginationDto){
    return null;
  }

  /**
   * 根据终端编码查询
   * @param terminalCode
   * @return
   */
  TerminalVo findByTerminalCode(String terminalCode);
}
