package com.biz.crm.cps.business.participator.sdk.vo;

import com.biz.crm.cps.business.common.sdk.vo.BaseIdVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * ContactPersonVo
 *
 * @Author: hefan
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ContactPersonVo", description = "终端联系人信息VO")
public class ContactPersonVo extends BaseIdVo {
  private static final long serialVersionUID = -3760484496116634843L;

  /**
   * 分利终端ID
   */
  @ApiModelProperty("分利终端ID")
  private String terminalId;

  /**
   * 联系人姓名
   */
  @ApiModelProperty("联系人姓名")
  private String contactPersonName;

  /**
   * 联系人电话
   */
  @ApiModelProperty("联系人电话")
  private String contactPersonPhone;
}
