package com.biz.crm.cps.business.participator.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 分利经销商-对接人信息vo
 * @Author: zengxingwang
 * @Date: 2021/7/19 14:34
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(description = "分利经销商-对接人信息vo")
public class DealerCommunicationVo {

  /**
   * 主键
   */
  @ApiModelProperty("主键")
  private String id;

  /**
   * 对接人职位编码
   */
  @ApiModelProperty("对接人职位编码")
  private String positionCode;

  /**
   * 对接人职位名称
   */
  @ApiModelProperty("对接人职位名称")
  private String positionName;

  /**
   * 对接人用户名编码
   */
  @ApiModelProperty("对接人用户名编码")
  private String userCode;

  /**
   * 对接人用户名
   */
  @ApiModelProperty("对接人用户名")
  private String userName;

  /**
   * 对接人所属组织编码
   */
  @ApiModelProperty("对接人所属组织编码")
  private String communicationOrgCode;

  /**
   * 对接人所属组织
   */
  @ApiModelProperty("对接人所属组织")
  private String communicationOrgName;

  /**
   * 对接人联系方式
   */
  @ApiModelProperty("对接人联系方式")
  private String communicationContact;

  /**
   * 上级客户编码
   */
  @ApiModelProperty("上级客户编码")
  private String superiorCustomerCode;

  /**
   * 上级客户名称
   */
  @ApiModelProperty("上级客户名称")
  private String superiorCustomerName;
}
