package com.biz.crm.cps.business.participator.sdk.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;

/**
 * 分利经销商信息vo
 * @Author: zengxingwang
 * @Date: 2021/7/19 11:10
 */
@Data
@ApiModel(description = "分利经销商信息vo")
public class DealerVo{

  /*************************************基本信息**********************************/

  /**
   * 主键
   */
  @ApiModelProperty("主键")
  private String id;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String customerCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  private String customerName;

  /**
   * 客户类型
   */
  @ApiModelProperty("客户类型")
  private String customerType;

  /**
   * 所属组织编码
   */
  @ApiModelProperty("所属组织编码")
  private String orgCode;

  /**
   * 所属组织名称
   */
  @ApiModelProperty("所属组织名称")
  private String orgName;

  /**
   * 渠道编码
   */
  @ApiModelProperty("渠道编码")
  private String channelCode;

  /**
   * 渠道名称
   */
  @ApiModelProperty("渠道名称")
  private String channelName;

  /**
   * 客户组织编码
   */
  @ApiModelProperty("客户组织编码")
  private String customerOrgCode;

  /**
   * 客户组织名称
   */
  @ApiModelProperty("客户组织名称")
  private String customerOrgName;

  /**
   * 省编码
   */
  @ApiModelProperty("省编码")
  private String provinceCode;

  /**
   * 省名称
   */
  @ApiModelProperty("省名称")
  private String provinceName;

  /**
   * 市编码
   */
  @ApiModelProperty("市编码")
  private String cityCode;

  /**
   * 市名称
   */
  @ApiModelProperty("市名称")
  private String cityName;

  /**
   * 区/县编码
   */
  @ApiModelProperty("区/县编码")
  private String districtCode;

  /**
   * 区名称
   */
  @ApiModelProperty("区/县名称")
  private String districtName;

  /**
   * 客户法人代表
   */
  @ApiModelProperty("客户法人代表")
  private String legalRepresent;

  /**
   * 客户联系方式
   */
  @ApiModelProperty("客户联系方式")
  private String customerContact;

  /**
   * 注册地址
   */
  @ApiModelProperty("注册地址")
  private String registeredAddress;

  /*********************************联系人信息**************************************/

  /**
   * 联系人信息
   */
  @ApiModelProperty("联系人信息")
  private Set<DealerContactPersonVo> dealerContactPersons;

  /*********************************对接人信息**************************************/

  /**
   * 对接人信息
   */
  @ApiModelProperty("对接人信息")
  private DealerCommunicationVo dealerCommunication;

  /*********************************关联终端**************************************/

  /**
   * 分利准入时间
   */
  @ApiModelProperty("分利准入时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss" , timezone = "GMT+8")
  private Date startTime;

  /**
   * 累计现金
   */
  @ApiModelProperty("累计现金")
  private BigDecimal accruingCash;

  /**
   * 累计积分
   */
  @ApiModelProperty("累计积分")
  private BigDecimal accruingIntegral;

  /**
   * 累计红包
   */
  @ApiModelProperty("累计红包")
  private BigDecimal accruingRedPacket;

  /**
   * 累计费用
   */
  @ApiModelProperty("累计费用")
  private BigDecimal accruingCost;

  /**
   * 分利状态
   */
  @ApiModelProperty("分利状态")
  private String enableStatus;

  /**
   * 虚拟账户状态
   */
  @ApiModelProperty("虚拟账户状态")
  private Integer accountStatus;

  /**
   * 创建人
   */
  @ApiModelProperty("创建人")
  private String createAccount;

  /**
   * 创建时间
   */
  @ApiModelProperty("创建时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss" , timezone = "GMT+8")
  private Date createTime;

  /**
   * 标签信息
   */
  @ApiModelProperty("标签信息")
  private String tagDescription;

  /**  仅为适配前端新增字段 */
  @ApiModelProperty("多标签名字")
  private String orgNameStr;
}
