package com.biz.crm.cps.business.participator.sdk.vo;

import com.biz.crm.cps.business.common.sdk.vo.BaseIdVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jdk.nashorn.internal.ir.Terminal;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 分利参与者标签vo
 * @author hefan
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ParticipatorTagVo", description = "分利参与者标签")
public class ParticipatorTagVo extends BaseIdVo {

  /**
   * 分利终端信息
   */
  @ApiModelProperty("分利终端信息")
  private Terminal terminal;

  /**
   * 分利参与者编码
   */
  @ApiModelProperty("分利参与者编码")
  private String participatorCode;

  /**
   * 标签类型
   */
  @ApiModelProperty("标签类型 0 不可删除 1 手动增删")
  private String tagType;

  /**
   * 标签描述
   */
  @ApiModelProperty("标签描述")
  private String tagDescription;

}

