package com.biz.crm.cps.business.participator.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 实际分利参与者
 * @Author: zengxingwang
 * @Date: 2021/8/16 14:42
 */
@Data
@ApiModel(description = "实际分利参与者")
public class ParticipatorVo {

  /**
   * ParticipatorTypeEnum
   * 参与者类型 1-经销商，2-终端，3-消费者
   */
  @ApiModelProperty("参与者类型")
  private String participatorType;

  /**
   * 参与者编码
   */
  @ApiModelProperty("参与者编码")
  private String participatorCode;

  /**
   * 参与者名称
   */
  @ApiModelProperty("参与者名称")
  private String participatorName;

  /**
   * 手机号
   */
  @ApiModelProperty("手机号")
  private String phone;

  /**
   * 参与者所属机构编码
   */
  @ApiModelProperty("参与者所属机构编码")
  private String orgCode;

  /**
   * 参与者所属机构名称
   */
  @ApiModelProperty("参与者所属机构名称")
  private String orgName;
  /**
   * 参与者所属渠道 
   */
  @ApiModelProperty("参与者所属渠道")
  private String channel;
}
