package com.biz.crm.cps.business.participator.sdk.vo;

import com.biz.crm.cps.business.common.sdk.vo.BaseIdVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * SupplyRelationshipVo
 * @Author: hefan
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SupplyRelationshipVo", description = "供货关系VO")
public class SupplyRelationshipVo extends BaseIdVo {
  private static final long serialVersionUID = 1466811193738800911L;

  /**
   * 分利终端ID
   */
  @ApiModelProperty("分利终端ID")
  private String terminalId;

  /**
   * 业务员
   */
  @ApiModelProperty("业务员")
  private String salesman;

  /**
   * 业务员组织
   */
  @ApiModelProperty("业务员组织")
  private String salesmanOrganization;

  /**
   * 上级客户
   */
  @ApiModelProperty("上级客户")
  private String superiorCustomer;

  /**
   * 外部（经销商）唯一标识
   */
  @ApiModelProperty("外部（经销商）唯一标识")
  private String externalIdentifier;
}
