package com.biz.crm.cps.business.participator.sdk.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * @author jerry7
 * 终端供货关系，从mdm同步过来
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
public class TerminalSupplyVo extends TenantFlagOpVo {

    /**
     * 供货关系分组
     */
    @ApiModelProperty("供货关系分组")
    private String supplyType;

    /**
     * 用户账号
     */
    @ApiModelProperty("用户账号")
    private String userName;

    /**
     * 终端编码
     */
    @ApiModelProperty("终端编码")
    private String terminalCode;


    /**
     * 组织编码
     */
    @ApiModelProperty("组织编码")
    private String orgCode;


    /**
     * 上级客户编码
     */
    @ApiModelProperty("上级客户编码")
    private String customerCode;

    /**
     * 职位编码
     **/
    @ApiModelProperty("职位编码")
    private String positionCode;

    /**
     * 销售公司
     */
    @ApiModelProperty("销售公司")
    private String saleCompany;

    /**
     * 渠道
     */
    @ApiModelProperty("渠道")
    private String channel;

  /**
   * 供货关系详情列表
     */
    @ApiModelProperty("供货关系详情列表")
    private List<TerminalSupplyDetailVo> terminalSupplyDetails;

}
