package com.biz.crm.cps.business.participator.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * TerminalVo
 *
 * @Author: hefan
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TerminalVo", description = "分利终端信息Vo")
public class TerminalVo extends TenantFlagOpVo {
  private static final long serialVersionUID = 387659478683373996L;

  /**
   * name = "terminal_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 分利终端编码 '"
   */
  @ApiModelProperty("分利终端编码")
  private String terminalCode;

  /**
   * name = "terminal_name", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 分利终端名称 '"
   */
  @ApiModelProperty("分利终端名称")
  private String terminalName;

  /**
   * name = "terminal_type", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 分利终端类型 '"
   */
  @ApiModelProperty("分利终端类型")
  private String terminalType;

  /**
   * name = "organization", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 所属组织 '"
   */
  @ApiModelProperty("所属组织")
  private String organization;

  /**
   * name = "organization_code", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 所属组织code '"
   */
  @ApiModelProperty("所属组织code")
  private String organizationCode;

  /**
   * name = "customer_organization", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 客户组织 '"
   */
  @ApiModelProperty("客户组织")
  private String customerOrganization;

  /**
   * name = "customer_organization_code", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 客户组织Code '"
   */
  @ApiModelProperty("客户组织Code")
  private String customerOrganizationCode;

  /**
   * name = "channel", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 渠道 '"
   */
  @ApiModelProperty("渠道")
  private String channel;

  /**
   * name = "channel_name", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 渠道名称 '"
   */
  @ApiModelProperty("渠道")
  private String channelName;

  /**
   * @Column(name = "legal_person_s_name", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 营业执照法人姓名 '")
   */
  @ApiModelProperty("营业执照法人姓名")
  private String legalPersonSName;

  /**
   *   @Column(name = "registration_number", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 营业执照注册号 '")
   */
  @ApiModelProperty("营业执照注册号")
  private String registrationNumber;

  /**
   *   @Column(name = "company_name", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 营业执照企业名称 '")
   */
  @ApiModelProperty("营业执照企业名称")
  private String companyName;

  /**
   *   @Column(name = "province_code", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '省编码'")
   */
  @ApiModelProperty("省编码")
  private String provinceCode;

  /**
   *   @Column(name = "province_name", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '省名称'")
   */
  @ApiModelProperty("省名称")
  private String provinceName;

  /**
   *   @Column(name = "city_code", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '市编码'")
   */
  @ApiModelProperty("市编码")
  private String cityCode;

  /**
   *   @Column(name = "city_name", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '市名称'")
   */
  @ApiModelProperty("市名称")
  private String cityName;

  /**
   *   @Column(name = "district_code", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '区编码'")
   */
  @ApiModelProperty("区编码")
  private String districtCode;

  /**
   *   @Column(name = "district_name", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '区名称'")
   */
  @ApiModelProperty("区名称")
  private String districtName;

  /**
   *   @Column(name = "terminal_address", length = 128, nullable = true, columnDefinition = "varchar(128) COMMENT '终端地址'")
   */
  @ApiModelProperty("终端地址")
  private String terminalAddress;

  /**
   *   @Column(name = "shop_sign_path", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '店招照片文件夹'")
   */
  @ApiModelProperty("店招照片文件夹")
  private String shopSignPath;

  /**
   *   @Column(name = "shop_sign_filename", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '店招照片文件名'")
   */
  @ApiModelProperty("店招照片文件名")
  private String shopSignFilename;

  /**
   *   @Column(name = "business_license_path", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '营业执照照片文件夹'")
   */
  @ApiModelProperty("营业执照照片文件夹")
  private String businessLicensePath;

  /**
   *   @Column(name = "business_license_filename", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '营业执照照片文件名'")
   */
  @ApiModelProperty("营业执照照片文件名")
  private String businessLicenseFilename;

  /**
   *   @Column(name = "audit_status", nullable = false, columnDefinition = "INT(11) COMMENT ' 审核状态 '")
   */
  @ApiModelProperty("审核状态")
  private String auditStatus;

  /**
   *   @Column(name = "superior_customer", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 上级客户 '")
   */
  @ApiModelProperty("上级客户")
  private String superiorCustomer;

  /**
   * @Column(name = "location", length = 32, note = "经纬度 格式（纬度,经度）")
   */
  @ApiModelProperty("经纬度 格式（纬度,经度）")
  private String location;

  /**
   * @Column(name = "longitude", length = 32, note = "经度")
   */
  @ApiModelProperty("经度")
  private String longitude;

  /**
   * @Column(name = "latitude", length = 32, note = "纬度")
   */
  @ApiModelProperty("纬度")
  private String latitude;

  /**
   * openId 只在注册终端时，用于回显数据时使用
   * @Column(name = "open_id", length = 64)
   */
  @ApiModelProperty("openId")
  private String openId;

  @ApiModelProperty("营业执照法人身份证")
  private String legalPersonSId;

  @ApiModelProperty("验证码")
  private String verificationCode;

  /**
   * 联系人信息
   *   @OneToMany(fetch = FetchType.LAZY,mappedBy = "terminal")
   */
  @ApiModelProperty("联系人信息")
  private Set<ContactPersonVo> contactPersons;

  /**
   * 供货关系
   *   @OneToMany(fetch = FetchType.LAZY,mappedBy = "terminal")
   */
  @ApiModelProperty("供货关系")
  private List<TerminalSupplyVo> terminalSupplies;

  /**
   * 验证结果(1.注册终端 2.加入分利终端 3.已存在)
   */
  @ApiModelProperty("验证结果(1.注册终端 2.加入分利终端 3.已存在)")
  private Integer resultType;

  @ApiModelProperty("提交时间")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss" , timezone = "GMT+8")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  private Date submitTime;

  @ApiModelProperty("审核时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss" , timezone = "GMT+8")
  private Date auditTime;

  @ApiModelProperty("驳回时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss" , timezone = "GMT+8")
  private Date rejectTime;

  @ApiModelProperty("分利终端来源")
  private String terminalSource;

  /**
   * 标签信息集合
   */
  @ApiModelProperty("标签信息集合")
  private Set<ParticipatorTagVo> participatorTags;

  /**
   * 标签信息字符串
   */
  @ApiModelProperty("标签信息字符串")
  private String tagDescription;

  /**
   * 供货关系详情字符串
   */
  @ApiModelProperty("供货关系字符串")
  private String supplyDescription;

  /**  仅为适配前端新增字段 */
  @ApiModelProperty("多标签名字")
  private String orgNameStr;
}
