package com.biz.crm.cps.business.policy.display.ladder.local.controller;

import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayPolicy;
import com.biz.crm.cps.business.policy.display.ladder.local.service.DisplayPolicyService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author HuaHongQiang
 * @date 2021/8/27 13:54
 */
@Slf4j
@RestController
@RequestMapping("/v1/display/policy")
@Api(tags = "陈列政策相关接口")
public class DisplayPolicyController {

  @Autowired
  private DisplayPolicyService displayPolicyService;

  @ApiOperation(value = "创建陈列政策(开发自测)")
  @PostMapping("")
  public Result<DisplayPolicy> create(@RequestBody DisplayPolicy displayPolicy) {
    try {
      DisplayPolicy policy = displayPolicyService.createFrom(displayPolicy);
      return Result.ok(policy);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "创建陈列政策(开发自测)")
  @GetMapping("findByTemplateCode")
  public Result<DisplayPolicy> findByTemplateCode(@RequestParam String templateCode) {
    try {
      DisplayPolicy policy = displayPolicyService.findByTemplateCode(templateCode);
      return Result.ok(policy);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
