package com.biz.crm.cps.business.policy.display.ladder.local.controller;

import com.biz.crm.cps.bisiness.policy.display.sdk.dto.DisplayTaskUploadHumanAuditDto;
import com.biz.crm.cps.bisiness.policy.display.sdk.vo.DisplayTaskAuditVo;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.policy.display.ladder.local.service.DisplayTaskAuditVoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 陈列任务审核相关
 *
 * @author sunx
 * @date 2021/12/17
 */
@Slf4j
@RestController
@RequestMapping("/v1/display/task/audit")
@Api(tags = "陈列任务审核相关")
public class DisplayTaskAuditVoController {

  @Autowired private DisplayTaskAuditVoService displayTaskAuditVoService;

  @ApiOperation(value = "根据业务单号获取任务明细审核明细信息")
  @GetMapping("findTaskAuditByBusinessCode")
  public Result<DisplayTaskAuditVo> findTaskAuditByBusinessCode(@RequestParam String businessCode) {
    try {
      DisplayTaskAuditVo displayTaskAuditVo =
          displayTaskAuditVoService.findTaskAuditByBusinessCode(businessCode);
      return Result.ok(displayTaskAuditVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "人工审核")
  @PostMapping("humanAudit")
  public Result<?> humanAudit(@RequestBody DisplayTaskUploadHumanAuditDto dto) {
    try {
      displayTaskAuditVoService.auditByHuman(dto);
      return Result.ok("操作成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
