package com.biz.crm.cps.business.policy.display.ladder.local.controller;

import com.biz.crm.cps.bisiness.policy.display.sdk.dto.DisplayTaskDto;
import com.biz.crm.cps.bisiness.policy.display.sdk.dto.DisplayTaskUploadInfoDto;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayTask;
import com.biz.crm.cps.business.policy.display.ladder.local.service.DisplayTaskService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author HuaHongQiang
 * @date 2021/8/27 13:55
 */
@Slf4j
@RestController
@RequestMapping("/v1/display/task")
@Api(tags = "陈列任务相关接口")
public class DisplayTaskController {

  @Autowired
  private DisplayTaskService displayTaskService;


  @ApiOperation(value = "创建陈列任务(开发自测)")
  @PostMapping("")
  public Result<List<DisplayTask>> create(@RequestBody String agreementId) {
    try {
      List<DisplayTask> displayTasks = displayTaskService.create(agreementId);
      return Result.ok(displayTasks);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "任务手动结算")
  @GetMapping("settlementDisplayTask")
  public Result<?> handleSettlementTask(@RequestParam String businessCode) {
    try {
      displayTaskService.handleSettlementTask(businessCode);
      return Result.ok("操作成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "修改审核状态(人工审核)")
  @PatchMapping("updateTaskStatus")
  public Result<?> updateTaskStatus(@RequestBody DisplayTaskDto displayTaskDto) {
    try {
      displayTaskService.updateTaskStatus(displayTaskDto);
      return Result.ok("操作成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "提交陈列任务图片信息")
  @PostMapping("submitDisplayTaskPictureInfo")
  public Result<?> handleSubmitDisplayTask(@RequestBody DisplayTaskUploadInfoDto displayTaskUploadInfoDto) {
    try {
      displayTaskService.handleSubmitDisplayTask(displayTaskUploadInfoDto);
      return Result.ok("操作成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 触发陈列任务方法
   *
   * @return
   */
  @ApiOperation(value = "触发陈列任务方法")
  @GetMapping("execDisplayTask")
  public Result<?> execDisplayTask() {
    try {
      displayTaskService.handleDisplayTask();
      return Result.ok("操作成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
